<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Proposal Inovasi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Proposal Inovasi</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <h4>Indikator</h4>

    <div class="card-header-action">
    <?php if(session()->get('id_hak_akses') == 6): ?>

        <a href="<?= base_url('admin/proposal_inovasi/TR2') ?>" class="btn btn-warning text-white">
            Kembali 
        </a>

    <?php else: ?>

        <a href="<?= base_url('admin/proposal_inovasi') ?>" class="btn btn-warning text-white">
            Kembali 
        </a>

    <?php endif ?>
        
    </div>
  </div>
  <div class="card-body">
  
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Indikator</th>
                <th>Keterangan</th>
                <th>Bobot</th>
                <th>Skor Mandiri</th>
                <th>Skor Verifikasi</th>
                <th>Pilih Parameter</th>
                <th>Data Pendukung</th>
            </tr>
          </thead>
          <tbody>
                <?php $no = 1; foreach($indikator as $ind): ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= $ind->nama ?></td>
                        <td><?= $ind->keterangan ?></td>
                        <td><?= $ind->bobot ?></td>
                        <td>
                            <?= \App\Helpers\InovakesHelper::GetNilaiProposalIndikator($id_proposal, $ind->id) ?>
                        </td>
                        <td>
                            <?= \App\Helpers\InovakesHelper::GetNilaiVerifikasiProposalIndikator($id_proposal, $ind->id) ?>
                        </td>
                        <td>
                            <?= \App\Helpers\InovakesHelper::GetParameterProposalIndikator($id_proposal, $ind->id) ?>

                            <?php if(\App\Helpers\InovakesHelper::IsAksesUpdateParameterDataPendukung($id_proposal)): ?>
                                <a href="javascript:;" data-toggle="modal" data-target="#modal-parameter" onclick="GetParameter(<?= $ind->id ?>)"><i class="fas fa-pencil-alt"></i> </a>
                            <?php endif ?>
                        </td>
                        <td>
                            <p><?= $ind->keterangan_data_pendukung ?></p>
                            <a href="<?= base_url('admin/proposal_inovasi/data_pendukung?id_proposal='.$id_proposal.'&id_indikator='.$ind->id) ?>" class="btn btn-primary btn-sm"><i class="fas fa-folder"></i> Upload</a>
                        </td>
                    </tr>
                <?php endforeach ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<div class="modal fade" id="modal-parameter" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Parameter</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data" action="<?= base_url('admin/proposal_inovasi/indikator/simpan_parameter') ?>">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Parameter</label> 
                                <select name="id_parameter" id="id_parameter" class="form-control" required>

                                </select>
                                <input type="hidden" name="id_proposal" id="id_proposal" value="<?= $id_proposal ?>">
                                <input type="hidden" name="id_indikator" id="id_indikator">
                            </div> 
                        </div>
                    </div>
                    <?php if(in_array(session()->get('id_hak_akses'), [1,3,4,5])): ?>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Keterangan Perubahan</label> 
                                <textarea name="keterangan_perubahan" id="keterangan_perubahan" class="form-control"></textarea>
                            </div> 
                        </div>
                    </div>
                    <?php endif ?>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var tableData = $("#tblData").DataTable({
        "lengthMenu": [ 100, 200, 300 ],
        "ordering": false
    });      

    function Hapus(id)
    {
        var url = "<?= base_url('admin/proposal_inovasi/hapus') ?>/" + id;
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = url;
            }
        });
    }  

    function GetParameter(id_indikator)
    {
        $("#id_indikator").val(id_indikator);
        $("#id_parameter").empty();
        var option = "";
        $.get("<?= base_url('admin/proposal_inovasi/get_parameter') ?>/" + id_indikator+"?id_proposal="+$("#id_proposal").val(), function(result){

            var id_selected = 0;
            var keterangan_perubahan = "";

            if(result.parameter_indikator != null)
            {
                id_selected = result.parameter_indikator.id_parameter;
                keterangan_perubahan = result.parameter_indikator.keterangan_perubahan;
            }

            console.log(result);

            $("#keterangan_perubahan").text(keterangan_perubahan);
                option += '<option value="">-- Silakan Pilih --</option>';
            $.each(result.parameter, function(i,l){

                option += '<option value='+ l.id + '|'+(l.nilai)+' '+ (id_selected == l.id ? "selected" : "") +'>'+l.nama+'</option>';

            });

            $("#id_parameter").html(option);
        });
    }
</script>

<?= $this->endSection() ?>