<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Proposal Inovasi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Proposal Inovasi</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Pemberian Nilai</h4>
  </div>
  <div class="card-body">
    
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/proposal_inovasi/simpan_penilaian') ?>">
    <?= csrf_field() ?>
    <input id="id_proposal" type="hidden" class="form-control" name="id_proposal" value="<?= $id_proposal ?>" required>
    <!-- <table class="table table-sm table-bordered">
        <thead>
            <tr>
                <th colspan="2">Format Penilaian Seleksi Final</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td width="25%">Tema Inovasi</td>
                <td>: <?= $proposal->tema ?></td>
            </tr>
            <tr>
                <td width="25%">Kategori Inovasi</td>
                <td>: <?= $proposal->kategori ?></td>
            </tr>
        </tbody>
    </table> -->

    <table class="table table-sm table-bordered">
        <thead>
            <tr>
                <th colspan="2">FORM PENILAIAN</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td width="25%">Jenis Inovasi</td>
                <td>: <?= $proposal->jenis ?></td>
            </tr>
            <tr>
                <td width="25%">Judul Inovasi</td>
                <td>: <?= $proposal->judul ?></td>
            </tr>
            <tr>
                <td width="25%">Nama Peserta</td>
                <td>: <?= $nama_user ?></td>
            </tr>
        </tbody>
    </table>

    <table class="table table-sm table-bordered">
        <thead>
            <!-- <tr>
                <th colspan="4">Bobot : 25 </th>
            </tr> -->
            <tr>
                <th>No</th>
                <th>Aspek yang Dinilai</th>
                <!-- <th>Indikator Penilaian</th> -->
                <th>Nilai</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($aspek_penilaian as $k => $p): ?>
            <tr>
                <td><?= ($k+1) ?></td>
                <td><?= $p->nama ?> </td>
                <td>
                    <input type="hidden" name="id_aspek_penilaian[]" value="<?= $p->id ?>">
                    <input type="number" class="form-control" name="nilai_penyajian[]" value="<?= \App\Helpers\InovakesHelper::GetNilaiJuri($id_proposal, $p->id) ?>" required>
                </td>
            </tr>
            <?php endforeach ?>
        </tbody>
    </table>

    <!-- <table class="table table-sm table-bordered">
        <thead>
            <tr>
                <th colspan="4">2. Substansi (Bobot 80%) </th>
            </tr>
            <tr>
                <th>No</th>
                <th>Aspek yang Dinilai</th>
                <th>Indikator Penilaian</th>
                <th>Nilai (1-5)</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($substansi as $k => $p): ?>
            <tr>
                <td><?= ($k+1) ?></td>
                <td><?= $p->nama_aspek_penilaian ?> </td>
                <td><?= $p->indikator_penilaian ?> </td>
                <td>
                    <input type="hidden" name="id_aspek_penilaian_indikator_substansi[]" value="<?= $p->id ?>">
                    <select name="nilai_substansi[]" class="form-control form-control-sm">
                        <option value="1" <?= \App\Helpers\InovakesHelper::GetNilai($id_proposal, $p->id, session()->get('user_id')) == 1 ? "selected" : "" ?>>1</option>
                        <option value="2" <?= \App\Helpers\InovakesHelper::GetNilai($id_proposal, $p->id, session()->get('user_id')) == 2 ? "selected" : "" ?>>2</option>
                        <option value="3" <?= \App\Helpers\InovakesHelper::GetNilai($id_proposal, $p->id, session()->get('user_id')) == 3 ? "selected" : "" ?>>3</option>
                        <option value="4" <?= \App\Helpers\InovakesHelper::GetNilai($id_proposal, $p->id, session()->get('user_id')) == 4 ? "selected" : "" ?>>4</option>
                        <option value="5" <?= \App\Helpers\InovakesHelper::GetNilai($id_proposal, $p->id, session()->get('user_id')) == 5 ? "selected" : "" ?>>5</option>
                    </select> 
                </td>
            </tr>
            <?php endforeach ?>
        </tbody>
    </table> -->

    <div class="form-group text-right">
    <?php if(!\App\Helpers\InovakesHelper::CheckJuriSudahSubmitPenilaian($id_proposal, session()->get('user_id'), $proposal->status)): ?>
        <button type="submit" class="btn btn-success">
            SUBMIT
        </button>
    <?php else: ?>
        <button type="submit" class="btn btn-success">
            UPDATE
        </button>
    <?php endif ?>

    
    
    <?php if($proposal->status == "PRESENTASI"): ?>
        <a href="<?= base_url('admin/proposal_inovasi/presentasi') ?>" class="btn btn-warning text-white">Kembali</a>
    <?php elseif($proposal->status == "PRESENTASI"): ?>
        <a href="<?= base_url('admin/proposal_inovasi/validasi_lapangan') ?>" class="btn btn-warning text-white">Kembali</a>
    <?php else: ?>
        <a href="<?= base_url('admin/proposal_inovasi') ?>" class="btn btn-warning text-white">Kembali</a>
    <?php endif ?>
    </div>
</form>
  </div>
</div>

<div class="card card-primary">
    <div class="card-header">
        <h4>Nilai Juri</h4>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-striped table-sm" id="tblJuri">
            <thead>
                <th>Nama Juri</th>
                <th>Total Nilai</th>
            </thead>
            <tbody>
                <?php foreach($juri as $val): ?>
                    <tr>
                        <td><?= $val->nama_juri ?></td>
                        <td><?= number_format($val->total_nilai,2) ?></td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script>
    $(".summernote").summernote();
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });
</script>
<?= $this->endSection() ?>