<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use App\Models\Dukcapil;
use Auth;

class DukcapilExport implements FromView
{
    protected $id_provinsi;
    protected $id_kabupaten;
    protected $status;

    public function __construct($id_provinsi, $id_kabupaten, $status)
    {
        $this->id_provinsi = $id_provinsi;
        $this->id_kabupaten = $id_kabupaten;
        $this->status = $status;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        $id_hak_akses = Auth::user()->id_hak_akses;

        $data = Dukcapil::select(['dukcapils.*','p.name as provinsi','r.name as kabupaten','i.skor as skor'])
                    ->join('provinces as p', 'dukcapils.id_provinsi','=','p.id')
                    ->join('regencies as r', 'dukcapils.id_kabupaten','=','r.id')
                    ->leftJoin('indeks_dukcapil as i','dukcapils.id','=','i.id_dukcapil');

        if($id_hak_akses == 1)
        {
            $data = $data;
        }
        else if($id_hak_akses == 3)
        {
            $data = $data->where('dukcapils.id_provinsi', Auth::user()->id_provinsi);
        }
        else if($id_hak_akses == 4)
        {
            $data = $data->where('dukcapils.id_kabupaten', Auth::user()->id_kabupaten);
        }
        else if($id_hak_akses == 5)
        {
            $data = $data->where('dukcapils.id_kecamatan', Auth::user()->id_kecamatan);
        }
        else if($id_hak_akses == 2)
        {
            $data = $data->where('dukcapils.id_user', Auth::user()->id);
        }
        else
        {
            $data = $data;
        }

        if($this->id_provinsi != null)
        {
            $data = $data->where('dukcapils.id_provinsi', $this->id_provinsi);
        }

        if($this->id_kabupaten != null)
        {
            $data = $data->where('dukcapils.id_kabupaten', $this->id_kabupaten);
        }

        if($this->status != 0)
        {
            if($this->status == SMUDESA::SANGAT_MISKIN)
            {
                $data = $data->where('i.skor','>',0)->where('i.skor','<=',1206);
            }
            else if($this->status == SMUDESA::MISKIN)
            {
                $data = $data->where('i.skor','>',1206)->where('i.skor','<=',1411);
            }
            else if($this->status == SMUDESA::HAMPIR_MISKIN)
            {
                $data = $data->where('i.skor','>',1411)->where('i.skor','<=',1511);
            }
            else if($this->status == SMUDESA::RENTAN_MISKIN)
            {
                $data = $data->where('i.skor','>',1511)->where('i.skor','<=',1601);
            }
            else if($this->status == SMUDESA::TIDAK_MISKIN)
            {
                $data = $data->where('i.skor','>',1601);
            }
            else if($this->status == SMUDESA::BELUM_INPUT_DATA)
            {
                $data = $data->whereNull('i.skor');
            }
        }

        $data = $data->get();

        return view('dukcapil.export', [
            'data' => $data
        ]);
    }
}
