<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Formulir;
use DataTables;

class FormulirController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Formulir::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->editColumn('file', function($data){

                        if($data->file == null)
                        {
                            return "-";
                        }
                        else
                        {
                            return "<a href=".asset('formulir/'. $data->file)."><i class='fas fa-download'></i></a>";
                        }
                    })
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }

    }

    public function index()
    {
    	return view('formulir.index');
    }

    public function index_formulir_user()
    {
        return view('formulir.index_formulir_user');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id_formulir;
        $nama       = $req->nama;
        $file       = $req->file;
        $keterangan = $req->keterangan;
        $pesan      = "";
        $nama_file  = null;

        if(!empty($id)) {

            $menus = Formulir::find($id);
            $nama_file  = $menus->file;
            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data Formulir berhasil diubah !',
                'alert-type' => 'success'
            );

        } else {

            $menus = new Formulir;

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data Formulir berhasil disimpan !',
                'alert-type' => 'success'
            );
        }

        if($file != null)
        {
            $nama_file = "formulir_".time().'.'.$file->extension();

            $file->move('formulir', $nama_file);
        }

        $menus->nama        = $nama;
        $menus->file        = $nama_file;
        $menus->keterangan  = $keterangan;
        $menus->save();

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data = Formulir::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Formulir::find($id)->delete();
        $msg = 'Menu berhasil dihapus';
        return ['message' => $msg];
    }
}
