<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Program;
use App\Models\Soal;
use App\Models\Jawaban;
use DB;

class KuisionerUjianController extends Controller
{
    public function index()
    {
        $data['program'] = Program::where('status', 'Aktif')->get();
        return view('kuisioner_ujian.index', $data);
    }

    public function index_setting_ujian($id_program)
    {
        $data['soal'] = Soal::where('id_program', $id_program)->get();
        $data['id_program'] = $id_program;
        $data['program'] = Program::find($id_program);
        return view('kuisioner_ujian.index_setting_ujian', $data);
    }

    public function tambah_soal(Request $req)
    {
        $id = $req->id_soal;

        if(!empty($id))
        {
            $soal = Soal::find($id);
            $soal->soal = $req->soal;
            $soal->skor = $req->skor;

            if($req->file != null)
            {
                $fileName = "soal_".time().'.'.$req->file->extension();  
   
                $req->file->move('soal', $fileName);

                $soal->file = $fileName;
            }
            else
            {
                $soal->file = null;
            }

            $soal->save();

            //Delete jawaban
            Jawaban::where('id_soal', $id)->delete();

            //Simpan Jawaban
            $jawabanA = new Jawaban;
            $jawabanA->id_soal = $soal->id;
            $jawabanA->jawaban = $req->pilihan_jawaban0;

            if($req->jawaban_benar == "0" || $req->jawaban_benar == 0)
            {
                $jawabanA->jawaban_benar = 1;
            }

            $jawabanA->save();

            $jawabanB = new Jawaban;
            $jawabanB->id_soal = $soal->id;
            $jawabanB->jawaban = $req->pilihan_jawaban1;


            if($req->jawaban_benar == "1" || $req->jawaban_benar == 1)
            {
                $jawabanB->jawaban_benar = 1;
            }

            $jawabanB->save();


            $jawabanC = new Jawaban;
            $jawabanC->id_soal = $soal->id;
            $jawabanC->jawaban = $req->pilihan_jawaban2;


            if($req->jawaban_benar == "2" || $req->jawaban_benar == 2)
            {
                $jawabanC->jawaban_benar = 1;
            }

            $jawabanC->save();

            $jawabanD = new Jawaban;
            $jawabanD->id_soal = $soal->id;
            $jawabanD->jawaban = $req->pilihan_jawaban3;


            if($req->jawaban_benar == "3" || $req->jawaban_benar == 3)
            {
                $jawabanD->jawaban_benar = 1;
            }

            $jawabanD->save();

            $jawabanE = new Jawaban;
            $jawabanE->id_soal = $soal->id;
            $jawabanE->jawaban = $req->pilihan_jawaban4;


            if($req->jawaban_benar == "4" || $req->jawaban_benar == 4)
            {
                $jawabanE->jawaban_benar = 1;
            }

            $jawabanE->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !', 
                'alert-type' => 'success'
            );
        }
        else
        {
            $soal = new Soal;
            $soal->id_program = $req->id_program;
            $soal->soal = $req->soal;
            $soal->skor = $req->skor;

            if($req->file != null)
            {
                $fileName = "soal_".time().'.'.$req->file->extension();  
   
                $req->file->move('soal', $fileName);

                $soal->file = $fileName;
            }

            $soal->save();

            //Simpan Jawaban
            $jawabanA = new Jawaban;
            $jawabanA->id_soal = $soal->id;
            $jawabanA->jawaban = $req->pilihan_jawaban0;

            if($req->jawaban_benar == "0" || $req->jawaban_benar == 0)
            {
                $jawabanA->jawaban_benar = 1;
            }

            $jawabanA->save();

            $jawabanB = new Jawaban;
            $jawabanB->id_soal = $soal->id;
            $jawabanB->jawaban = $req->pilihan_jawaban1;


            if($req->jawaban_benar == "1" || $req->jawaban_benar == 1)
            {
                $jawabanB->jawaban_benar = 1;
            }

            $jawabanB->save();


            $jawabanC = new Jawaban;
            $jawabanC->id_soal = $soal->id;
            $jawabanC->jawaban = $req->pilihan_jawaban2;


            if($req->jawaban_benar == "2" || $req->jawaban_benar == 2)
            {
                $jawabanC->jawaban_benar = 1;
            }

            $jawabanC->save();

            $jawabanD = new Jawaban;
            $jawabanD->id_soal = $soal->id;
            $jawabanD->jawaban = $req->pilihan_jawaban3;


            if($req->jawaban_benar == "3" || $req->jawaban_benar == 3)
            {
                $jawabanD->jawaban_benar = 1;
            }

            $jawabanD->save();

            $jawabanE = new Jawaban;
            $jawabanE->id_soal = $soal->id;
            $jawabanE->jawaban = $req->pilihan_jawaban4;


            if($req->jawaban_benar == "4" || $req->jawaban_benar == 4)
            {
                $jawabanE->jawaban_benar = 1;
            }

            $jawabanE->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !', 
                'alert-type' => 'success'
            );
        }

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function hapus_soal($id_soal)
    {
        DB::beginTransaction();

        try {

            Soal::find($id_soal)->delete();

            DB::commit();

            $msg = 'Data berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        } 
    }

    public function edit_soal($id_soal)
    {
        $soal = Soal::find($id_soal);
        $jawaban = Jawaban::where('id_soal', $id_soal)->get();

        $data['soal'] = $soal;
        $data['jawaban'] = $jawaban;

        return response()->json($data, 200);
    }
}
