<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use App\Models\Pembayaran;
use Carbon\Carbon;

class PaymentController extends Controller
{
    public function checkout($id_pembayaran)
    {
        $pembayaran = Pembayaran::with('pendaftaran_program')->find($id_pembayaran);
        return $this->_generatePaymentTokenAndRedirect($pembayaran);
    }

    private function _generatePaymentTokenAndRedirect($order)
	{
		$this->initPaymentGateway();

		$customerDetails = [
			'first_name' => $order->pendaftaran_program->user->name,
			'email' => $order->pendaftaran_program->user->email,
			'phone' => $order->pendaftaran_program->user->no_telp,
		];

		$params = [
			'enable_payments' => Pembayaran::PAYMENT_CHANNELS,
			'transaction_details' => [
				'order_id' => $order->no_transaksi,
				'gross_amount' => $order->total_bayar,
			],
			'customer_details' => $customerDetails,
			'expiry' => [
				'start_time' => date('Y-m-d H:i:s T'),
				'unit' => Pembayaran::EXPIRY_UNIT,
				'duration' => Pembayaran::EXPIRY_DURATION,
			],
		];

		$snap = \Midtrans\Snap::createTransaction($params);
        
		if ($snap->token) {
			$order->payment_token = $snap->token;
			$order->payment_url = $snap->redirect_url;
			$order->save();

            try {
                // Get Snap Payment Page URL
                $paymentUrl = \Midtrans\Snap::createTransaction($params)->redirect_url;
                
                return redirect()->away($paymentUrl);
            }
            catch (Exception $e) {
                echo $e->getMessage();
            }
		}
        else
        {
            echo "Credential Error!";
        }
	}

	/**
	 * Receive notification from payment gateway
	 *
	 * @param Request $request payment data
	 *
	 * @return json
	 */
	public function notification(Request $request)
	{
		$payload = $request->getContent();
		$notification = json_decode($payload);

		$validSignatureKey = hash("sha512", $notification->order_id . $notification->status_code . $notification->gross_amount . env('MIDTRANS_SERVER_KEY'));

		if ($notification->signature_key != $validSignatureKey) {
			return response(['message' => 'Invalid signature'], 403);
		}

		$this->initPaymentGateway();
		$statusCode = null;

		$paymentNotification = new \Midtrans\Notification();
		$order = Pembayaran::where('no_transaksi', $paymentNotification->order_id)->firstOrFail();

		if ($order->status == "Telah Dibayar") {
			return response(['message' => 'The order has been paid before'], 422);
		}

		$transaction = $paymentNotification->transaction_status;
		$type = $paymentNotification->payment_type;
		$orderId = $paymentNotification->order_id;
		$fraud = $paymentNotification->fraud_status;

		$vaNumber = null;
		$vendorName = null;
		if (!empty($paymentNotification->va_numbers[0])) {
			$vaNumber = $paymentNotification->va_numbers[0]->va_number;
			$vendorName = $paymentNotification->va_numbers[0]->bank;
		}

		$paymentStatus = null;
		if ($transaction == 'capture') {
			// For credit card transaction, we need to check whether transaction is challenge by FDS or not
			if ($type == 'credit_card') {
				if ($fraud == 'challenge') {
					// TODO set payment status in merchant's database to 'Challenge by FDS'
					// TODO merchant should decide whether this transaction is authorized or not in MAP
					$paymentStatus = Pembayaran::CHALLENGE;
				} else {
					// TODO set payment status in merchant's database to 'Success'
					$paymentStatus = Pembayaran::SUCCESS;
				}
			}
		} else if ($transaction == 'settlement') {
			// TODO set payment status in merchant's database to 'Settlement'
			$paymentStatus = Pembayaran::SETTLEMENT;
		} else if ($transaction == 'pending') {
			// TODO set payment status in merchant's database to 'Pending'
			$paymentStatus = Pembayaran::PENDING;
		} else if ($transaction == 'deny') {
			// TODO set payment status in merchant's database to 'Denied'
			$paymentStatus = Pembayaran::DENY;
		} else if ($transaction == 'expire') {
			// TODO set payment status in merchant's database to 'expire'
			$paymentStatus = Pembayaran::EXPIRE;
		} else if ($transaction == 'cancel') {
			// TODO set payment status in merchant's database to 'Denied'
			$paymentStatus = Pembayaran::CANCEL;
		}

		$status = $order->status;
		if (in_array($paymentStatus, [Pembayaran::SUCCESS, Pembayaran::SETTLEMENT])) {
			$status = "Telah Dibayar";
		}

		$paymentParams = [
			'tanggal_pembayaran' => Carbon::now(),
			'payment_amount' => $paymentNotification->gross_amount,
			'payment_method' => 'midtrans',
			'status' => $status,
			'payment_status' => $paymentStatus,
			'payment_token' => $paymentNotification->transaction_id,
			'payment_payloads' => $payload,
			'payment_type' => $paymentNotification->payment_type,
			'payment_va_number' => $vaNumber,
			'payment_vendor_name' => $vendorName,
			'payment_biller_code' => $paymentNotification->biller_code,
			'payment_bill_key' => $paymentNotification->bill_key,
		];

		$payment = Pembayaran::where('no_transaksi', $order->no_transaksi)->update($paymentParams);

		$message = 'Payment status is : '. $paymentStatus;

		$response = [
			'code' => 200,
			'message' => $message,
		];

		return response($response, 200);
	}

	/**
	 * Show completed payment status
	 *
	 * @param Request $request payment data
	 *
	 * @return void
	 */
	public function completed(Request $request)
	{
		// $code = $request->query('order_id');
		// $order = Pembayaran::where('no_transaksi', $code)->firstOrFail();
		// dd("completed");
		// if ($order->payment_status == Order::UNPAID) {
		// 	return redirect('payments/failed?order_id='. $code);
		// }

		$data['success'] = true;
		$data['message'] = "Thank you for completing the payment process!";

		return view('pembayaran.result', $data);
	}

	/**
	 * Show unfinish payment page
	 *
	 * @param Request $request payment data
	 *
	 * @return void
	 */
	public function unfinish(Request $request)
	{
		// $code = $request->query('order_id');
		// $order = Pembayaran::where('no_transaksi', $code)->firstOrFail();

		$data['success'] = false;
		$data['message'] = "Sorry, we couldn't process your payment.";

		return view('pembayaran.result', $data);
	}

	/**
	 * Show failed payment page
	 *
	 * @param Request $request payment data
	 *
	 * @return void
	 */
	public function failed(Request $request)
	{
		// $code = $request->query('order_id');
		// $order = Pembayaran::where('no_transaksi', $code)->firstOrFail();
		// dd("Failed");
		// \Session::flash('error', "Sorry, we couldn't process your payment.");

		$data['success'] = false;
		$data['message'] = "Sorry, we couldn't process your payment.";

		return view('pembayaran.result', $data);
	}

    public function selesai_pembayaran()
    {
        $order_id = request()->get('order_id');
        $transanction_status = request()->get('transanction_status');

        dd($order_id, $transanction_status);
    }
}
