<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pengajaran;
use App\Models\Pembayaran;
use Carbon\Carbon;
use DB;
use DataTables;
use App\Models\Program;
use App\Models\Materi;
use Auth;

class PengajaranController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Pengajaran::select(['pengajarans.*','p.nama as nama_program','m.nama as nama_materi'])
                        ->join('programs as p','pengajarans.id_program','=','p.id')
                        ->join('materis as m','pengajarans.id_materi','=','m.id')
                        ->get();

            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                                <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';

                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })
                    ->addColumn('pukul', function ($id) {

                        return date('H:i', strtotime($id->jam_mulai))." s.d ". date('H:i', strtotime($id->jam_selesai));
                    })
                    ->addColumn('pengajar', function ($id) {

                        return $id->program->pengajar->nama ?? "N/A";
                    })
                    ->editColumn('tanggal', function ($id) {

                        return date('d-M-Y', strtotime($id->tanggal));
                    })
                    ->make(true);
        }

    }

    public function get_data_pengajaran_saya(Request $request)
    {
        if ($request->ajax()) {
            $data_bayar = Pengajaran::select(['pengajarans.*','p.nama as nama_program','m.nama as nama_materi'])
                        ->join('pendaftaran_programs as a', 'pengajarans.id_program','=','a.id_program')
                        ->join('pembayarans as b','a.id','=','b.id_pendaftaran_program')
                        ->join('programs as p','pengajarans.id_program','=','p.id')
                        ->join('materis as m','pengajarans.id_materi','=','m.id')
                        ->where('b.status', Pembayaran::TELAHDIBAYAR)
                        ->where('a.id_user', Auth::user()->id);

            $data_gratis = Pengajaran::select(['pengajarans.*','p.nama as nama_program','m.nama as nama_materi'])
                        ->join('pendaftaran_programs as a', 'pengajarans.id_program','=','a.id_program')
                        ->join('programs as p', 'pengajarans.id_program','=','p.id')
                        ->join('materis as m','pengajarans.id_materi','=','m.id')
                        ->where('a.id_user', Auth::user()->id)
                        ->where('p.is_pembayaran', 0);

            $data = $data_bayar->union($data_gratis)->get();

            // baru sampai sini

            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                                <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';

                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })
                    ->addColumn('pukul', function ($id) {

                        return date('H:i', strtotime($id->jam_mulai))." s.d ". date('H:i', strtotime($id->jam_selesai));
                    })
                    ->addColumn('pengajar', function ($id) {

                        return $id->program->pengajar->nama ?? "N/A";
                    })
                    ->editColumn('tanggal', function ($id) {

                        return date('d-M-Y', strtotime($id->tanggal));
                    })
                    ->make(true);
        }

    }

    public function index()
    {
    	$program = Program::where('status', 'Aktif')->get();

        $data['program'] = $program;
    	return view('pengajaran.index', $data);
    }

    public function index_pengajaran_saya()
    {
        return view('pengajaran.index_pengajaran_saya');
    }

    public function tambah(Request $req)
    {
        $id             = $req->id_pengajaran;
        $id_program     = $req->id_program;
        $id_materi      = $req->id_materi;
        $tanggal        = $req->tanggal;
        $jam_mulai      = $req->jam_mulai;
        $jam_selesai    = $req->jam_selesai;
        $link_zoom      = $req->link_zoom;
        $pesan          = "";

        if(!empty($id)) {

            $menus = Pengajaran::find($id);
            $menus->id_program        = $id_program;
            $menus->id_materi         = $id_materi;
            $menus->tanggal           = $tanggal;
            $menus->jam_mulai         = $jam_mulai;
            $menus->jam_selesai       = $jam_selesai;
            $menus->link_zoom         = $link_zoom;
            $menus->updated_at        = Carbon::now();
            $menus->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !',
                'alert-type' => 'success'
            );

        } else {

            $menus = new Pengajaran;
            $menus->id_program        = $id_program;
            $menus->id_materi         = $id_materi;
            $menus->tanggal           = $tanggal;
            $menus->jam_mulai         = $jam_mulai;
            $menus->jam_selesai       = $jam_selesai;
            $menus->link_zoom         = $link_zoom;
            $menus->created_at        = Carbon::now();
            $menus->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !',
                'alert-type' => 'success'
            );
        }

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data = Pengajaran::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
    	DB::beginTransaction();

        try {

            Pengajaran::find($id)->delete();

            DB::commit();

            $msg = 'Data berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        }
    }

    public function get_materi($id_program)
    {
        $materi = Materi::where('id_program', $id_program)->get();

        return response()->json($materi, 200);
    }
}
