<?php

namespace App\Http\Controllers;

use App\Http\Requests\PengajuanHakiRequest;
use App\Models\BidangTeknologi;
use App\Models\JenisHaki;
use App\Models\JenisPaten;
use App\Models\PengajuanHaki;
use App\Models\PengajuanHakiFilePendukung;
use App\Models\PengajuanHakiKolabolator;
use App\Models\SatuanKerja;
use App\Services\PengajuanHakiService;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\Auth;

class PengajuanHakiController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            if(Auth::user()->id_hak_akses == 1)
                $data = PengajuanHaki::with(['jenis_haki','user']);
            else
                $data = PengajuanHaki::with(['jenis_haki','user'])->where('id_user', Auth::user()->id);

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<a href='.url('ajukan-haki/'.$id->id.'/edit').' title="Edit" class="btn btn-primary">Edit</a>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->editColumn('created_at', function ($id) {
                        return date('d M Y', strtotime($id->created_at));
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('pengajuan_haki.index');
    }

    public function tambah()
    {
        $data['jenis_haki'] = JenisHaki::all();
        $data['satuan_kerja'] = SatuanKerja::all();
    	return view('pengajuan_haki.tambah', $data);
    }

    public function simpan(PengajuanHakiRequest $request, PengajuanHakiService $service)
    {
        $service->save($request);

        return redirect('ajukan-haki')->with('pesan', [
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan!',
            'alert-type' => 'success'
        ]);
    }

    public function edit($id)
    {
        $data['pengajuan_haki'] = PengajuanHaki::findorFail($id);
        $data['jenis_haki'] = JenisHaki::all();
        $data['satuan_kerja'] = SatuanKerja::all();

        return view('pengajuan_haki.edit', $data);
    }

    public function hapus(PengajuanHakiService $service, $id)
    {
        $service->delete($id);

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    public function get_form_by_jenis_haki($id_jenis_haki, $id_pengajuan_haki = 0)
    {
        $result = "";
        $pengajuan_haki = PengajuanHaki::find($id_pengajuan_haki);
        $data['pengajuan_haki'] = $pengajuan_haki;
        switch ($id_jenis_haki) {
            case 1: // Merek
                $result = view('pengajuan_haki.merek', $data)->render();
                break;

            case 2: // Paten
                $data['jenis_paten'] = JenisPaten::all();
                $data['bidang_teknologi'] = BidangTeknologi::all();
                $result = view('pengajuan_haki.paten', $data)->render();
                break;

            case 4: // PVT
                $result = view('pengajuan_haki.perlindungan_varietas_tanaman', $data)->render();
                break;

            case 5: // Hak Cipta
                $data['jenis_paten'] = JenisPaten::all();
                $data['bidang_teknologi'] = BidangTeknologi::all();
                $result = view('pengajuan_haki.hak_cipta', $data)->render();
                break;

            case 7: // Indikasi Geografis
                $result = view('pengajuan_haki.indikasi_geografis', $data)->render();
                break;

            case 8: // DTLST
                $result = view('pengajuan_haki.desain_tata_letak_sirkuit_terpadu', $data)->render();
                break;
        }

        return $result;
    }

    public function hapus_file_pendukung(PengajuanHakiService $service, $filename)
    {
        PengajuanHakiFilePendukung::where('file', $filename)->delete();
        $service->deleteFile('file_pendukung', $filename);
        $data['message'] = 'File berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    public function hapus_file_kolabolator(PengajuanHakiService $service, $id, $path)
    {
        $delete = PengajuanHakiKolabolator::find($id);
        $service->deleteFile('file_ktp_kolabolator_'.$path, $delete->file_ktp);
        $service->deleteFile('file_npwp_kolabolator_'.$path, $delete->file_npwp);
        PengajuanHakiKolabolator::find($id)->delete();
        $data['message'] = 'File berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
