<?php

namespace App\Http\Controllers;

use App\Http\Requests\PerbaikanHakiRequest;
use App\Models\BidangTeknologi;
use App\Models\JenisHaki;
use App\Models\JenisPaten;
use App\Models\PengajuanHaki;
use App\Models\PerbaikanHaki;
use App\Models\PerbaikanHakiFilePendukung;
use App\Models\PerbaikanHakiKolabolator;
use App\Models\SatuanKerja;
use App\Services\PerbaikanHakiService;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\Auth;

class PerbaikanHakiController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            if(Auth::user()->id_hak_akses == 1)
                $data = PerbaikanHaki::with(['jenis_haki','user']);
            else
                $data = PerbaikanHaki::with(['jenis_haki','user'])->where('id_user', Auth::user()->id);

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<a href='.url('perbaikan-haki/'.$id->id.'/edit').' title="Edit" class="btn btn-primary">Edit</a>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->editColumn('created_at', function ($id) {
                        return date('d M Y', strtotime($id->created_at));
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('perbaikan_haki.index');
    }

    public function tambah()
    {
        $data['jenis_haki'] = JenisHaki::all();

        if(Auth::user()->id_hak_akses == 1)
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->get();
        else
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->where('id_user', Auth::user()->id)->get();

        $data['pengajuan_haki'] = $pengajuan_haki;
    	return view('perbaikan_haki.tambah', $data);
    }

    public function simpan(Request $req, PerbaikanHakiService $service)
    {
        $pengajuan = PengajuanHaki::where('kode_pengajuan', $req->kode_pengajuan)->first();
        $id_perbaikan = $service->copyFromPengajuan($pengajuan->id);
        $data['pengajuan_haki'] = PerbaikanHaki::findorFail($id_perbaikan);
        $data['jenis_haki'] = JenisHaki::all();
        $data['satuan_kerja'] = SatuanKerja::all();

        return view('perbaikan_haki.edit', $data);

        // $pesan = array(
        //     'header' => 'Terima Kasih',
        //     'message' => 'Data berhasil disimpan !',
        //     'alert-type' => 'success'
        // );

        // session()->put('pesan',$pesan);

        // return redirect('perbaikan-haki')->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data['pengajuan_haki'] = PerbaikanHaki::findOrfail($id);
        $data['jenis_haki'] = JenisHaki::all();
        $data['satuan_kerja'] = SatuanKerja::all();

        return view('perbaikan_haki.edit', $data);
    }

    public function update(PerbaikanHakiRequest $request,PerbaikanHakiService $service)
    {
        $service->update($request);

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('perbaikan-haki')->with('pesan', $pesan);
    }

    public function hapus($id)
    {
        PerbaikanHaki::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    function get_pengajuan_haki($kode_pengajuan)
    {
        $pengajuan_haki = PengajuanHaki::where('kode_pengajuan', $kode_pengajuan)->first();

        $data['pengajuan_haki'] = $pengajuan_haki;

        return response()->json($pengajuan_haki, 200);
    }

    public function get_form_by_jenis_haki($id_jenis_haki, $id_perbaikan_haki = 0)
    {
        $result = "";
        $pengajuan_haki = PerbaikanHaki::find($id_perbaikan_haki);
        $data['pengajuan_haki'] = $pengajuan_haki;
        switch ($id_jenis_haki) {
            case 1: // Merek
                $result = view('pengajuan_haki.merek', $data)->render();
                break;

            case 2: // Paten
                $data['jenis_paten'] = JenisPaten::all();
                $data['bidang_teknologi'] = BidangTeknologi::all();
                $result = view('pengajuan_haki.paten', $data)->render();
                break;

            case 4: // PVT
                $result = view('pengajuan_haki.perlindungan_varietas_tanaman', $data)->render();
                break;

            case 5: // Hak Cipta
                $data['jenis_paten'] = JenisPaten::all();
                $data['bidang_teknologi'] = BidangTeknologi::all();
                $result = view('pengajuan_haki.hak_cipta', $data)->render();
                break;

            case 7: // Indikasi Geografis
                $result = view('pengajuan_haki.indikasi_geografis', $data)->render();
                break;

            case 8: // DTLST
                $result = view('pengajuan_haki.desain_tata_letak_sirkuit_terpadu', $data)->render();
                break;
        }

        return $result;
    }

    public function hapus_file_pendukung(PerbaikanHakiService $service, $filename)
    {
        PerbaikanHakiFilePendukung::where('file', $filename)->delete();
        $service->deleteFile('perbaikan/file_pendukung', $filename);
        $data['message'] = 'File berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    public function hapus_file_kolabolator(PerbaikanHakiService $service, $id, $path)
    {
        $delete = PerbaikanHakiKolabolator::find($id);
        $service->deleteFile('perbaikan/file_ktp_kolabolator_'.$path, $delete->file_ktp);
        $service->deleteFile('perbaikan/file_npwp_kolabolator_'.$path, $delete->file_npwp);
        PerbaikanHakiKolabolator::find($id)->delete();
        $data['message'] = 'File berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
