<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sertifikat;
use App\Models\Program;
use Auth;
use DB;
use PDF;

class SertifikatController extends Controller
{
    public function index()
    {
        $sertifikat = Sertifikat::select([DB::raw('MAX(a.nama) as program, MAX(b.nama) as pengajar, a.id as id_program')])
                        ->join('programs as a', 'sertifikats.id_program','=','a.id')
                        ->join('pengajars as b', 'a.id_pengajar','=','b.id')
                        ->groupBy('a.id')
                        ->get();

        $data['sertifikat'] = $sertifikat;

        return view('sertifikat.index', $data);
    }

    public function index_sertifikat_saya()
    {
        $id_user = Auth::user()->id;
        $sertifikat = Sertifikat::where('id_user', $id_user)->get();

        $data['sertifikat'] = $sertifikat;

        return view('sertifikat.index_sertifikat_saya', $data);
    }

    public function lihat_peserta($di_program)
    {
        $sertifikat = Sertifikat::where('id_program', $di_program)->get();
        $program = Program::find($di_program);
        $data['sertifikat'] = $sertifikat;
        $data['program'] = $program;

        return view('sertifikat.lihat_peserta', $data);
    }

    public function generate_sertifikat($id)
    {
        $sertifikat = Sertifikat::find($id);

        if($sertifikat == null)
        {
            echo "Anda tidak punya sertifikat!";
        }

        $data = [
            'sertifikat' => $sertifikat
        ];

        $pdf = PDF::loadView('sertifikat.cetak', $data);

        return $pdf->download('sertifikat_'.$sertifikat->program->nama.'_'.$sertifikat->user->name.'.pdf');
    }
}
