<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DataTables;
use App\Models\User;
use App\Models\HakAkses;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\Kecamatan;
use App\Models\Agama;
use App\Models\Kelurahan;
use App\Models\JenisPekerjaan;
use App\Models\PendidikanTerakhir;
use App\Models\Dukcapil;
use Carbon\Carbon;
use DB;
use Auth;

class UserController extends Controller
{
    public function index()
    {
    	$hak_akses = HakAkses::whereIn('id',[1,2,3,4])->get();
        $data['hak_akses'] = $hak_akses;
    	return view('user.index', $data);
    }

    public function getData()
    {
    	$data = User::GetList();

    	$table = DataTables::of($data)
    				->escapeColumns([])
    				->addColumn('aksi', function ($id) {
                    	return '<button data-toggle="modal" data-target="#modal-tambah" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                    		<button class="btn btn-danger" onclick="hapus('.$id->id.');">Hapus</button>';
                	})
                	->editColumn('is_aktif', function ($aksi) {

	                    if ($aksi->is_aktif == 1) {
	                        $b = '<div class="badge badge-success badge-shadow">Aktif</div>';
	                    }else{
	                        $b = '<div class="badge badge-danger badge-shadow">Tidak Aktif</div>';
	                    }
	                    return $b;
	                });

    	return $table->make('true');
    }

    public function tambah(Request $req)
    {
    	$msg = "";
        $id = $req->id_user;
        if(!empty($id))
        {
        	$user = User::find($id);
        	$user->nik = $req->nik;
        	$user->no_kk = $req->no_kk;
        	$user->name = $req->name;
        	$user->email = $req->email;
        	$user->password = bcrypt($req->password);
            $user->id_hak_akses = $req->id_hak_akses;
        	$user->is_aktif = $req->is_aktif;
        	$user->id_provinsi = $req->id_provinsi;
        	$user->id_kabupaten = $req->id_kabupaten;
        	$user->id_kecamatan = $req->id_kecamatan;
        	$user->updated_at = Carbon::now();
        	$user->save();

            $dukcapil = Dukcapil::where('id_user', $id)->first();
            $dukcapil->nik = $req->nik;
            $dukcapil->no_kk = $req->no_kk;
            $dukcapil->nama_lengkap = $req->name;
            $dukcapil->id_provinsi = $req->id_provinsi;
        	$dukcapil->id_kabupaten = $req->id_kabupaten;
        	$dukcapil->id_kecamatan = $req->id_kecamatan;
            $dukcapil->save();

            $msg = "Data berhasil diperbaharui !";

        } else {

            $this->validate($req, [
                    'email' => 'unique:users',
                    'username' => 'unique:users',
                ],
                [
                    'email.unique' => 'Alamat email sudah terdaftar',
                    'username.unique' => 'Username sudah terdaftar'
                ]
            );

            $user = new User;
            $user->nik = $req->nik;
        	$user->no_kk = $req->no_kk;
        	$user->name = $req->name;
        	$user->email = $req->email;
            $user->password = bcrypt($req->password);
            $user->id_hak_akses = $req->id_hak_akses;
            $user->is_aktif = $req->is_aktif;
            $user->id_provinsi = $req->id_provinsi;
        	$user->id_kabupaten = $req->id_kabupaten;
        	$user->id_kecamatan = $req->id_kecamatan;
        	$user->created_at = Carbon::now();
        	$user->save();

            $dukcapil = new Dukcapil;
            $dukcapil->code = $req->nik.".".$req->no_kk;
            $dukcapil->nik = $req->nik;
            $dukcapil->no_kk = $req->no_kk;
            $dukcapil->nama_lengkap = $req->name;
            $dukcapil->id_provinsi = $req->id_provinsi;
        	$dukcapil->id_kabupaten = $req->id_kabupaten;
        	$dukcapil->id_kecamatan = $req->id_kecamatan;
        	$dukcapil->id_user = $user->id;
            $dukcapil->save();

            $msg = "Data berhasil ditambahkan !";
        }

		$pesan = array(
            'header' => 'Terima Kasih',
            'message' => $msg,
            'alert-type' => 'success'
        );

		session()->put('pesan',$pesan);

		return redirect()->back()->with('pesan', $pesan);
    }

    public function edit($id)
    {
        $data = User::find($id);

        return $data;
    }

    public function hapus($id)
    {
    	DB::beginTransaction();

        try {

            User::find($id)->delete();

            DB::commit();

            $msg = 'User berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        }


    }

    public function profile()
    {
        $agama = Agama::all();
        $jenis_pekerjaan = JenisPekerjaan::all();
        $pendidikan_terakhir = PendidikanTerakhir::all();
        $dukcapil = Dukcapil::where('id_user', Auth::user()->id)->first();

        $data['dukcapil'] = $dukcapil;
        $data['provinsi'] = Provinsi::find($dukcapil->id_provinsi);
        $data['kabupaten'] = Kabupaten::find($dukcapil->id_kabupaten);
        $data['kecamatan'] = Kecamatan::find($dukcapil->id_kecamatan);
        $data['kelurahan'] = Kelurahan::find($dukcapil->id_kelurahan);
        $data['agama'] = $agama;
        $data['jenis_pekerjaan'] = $jenis_pekerjaan;
        $data['pendidikan_terakhir'] = $pendidikan_terakhir;

        return view('user.profile', $data);
    }

    public function update_profile(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            // 'nik' => 'required|string|max:255',
            // 'tanggal_lahir' => 'required',
            // 'jenis_kelamin' => 'required',
            // 'id_provinsi' => 'required',
            // 'id_kabupaten' => 'required',
            // 'alamat' => 'required|string|max:500',
            // 'no_telp' => 'required|string|max:20',
            'email' => 'required|string|email|max:255',
            // 'password' => ['required', 'confirmed', Rules\Password::min(6)],
            // 'file_pendukung' => 'mimes:jpg,jpeg,png|max:2048',
        ]);

        $email_eksis = User::where('email', $request->email)
                        ->where('id','<>', Auth::user()->id)
                        ->exists();

        if($email_eksis)
        {
            $pesan = array(
                'header' => 'GAGAL',
                'message' => "Email telah terdaftar!",
                'alert-type' => 'error'
            );

            session()->put('pesan',$pesan);

            return redirect()->back()->with('pesan', $pesan);
        }

        // $fileName = Auth::user()->file_pendukung;

        // if(!empty($request->file_pendukung))
        // {
        //     $fileName = $request->name."_".time().'.'.$request->file_pendukung->extension();
        //     $request->file_pendukung->move(public_path('file_pendukung'), $fileName);
        // }

        $user = User::find(Auth::user()->id);
        $user->nik = $request->nik;
        $user->no_kk = $request->no_kk;
        $user->name = $request->name;
        $user->email = $request->email;

        if($request->password != null)
            $user->password = bcrypt($request->password);

        $user->id_provinsi = $request->id_provinsi;
        $user->id_kabupaten = $request->id_kabupaten;
        $user->id_kecamatan = $request->id_kecamatan;
        $user->updated_at = Carbon::now();
        $user->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => "Profile updated!",
            'alert-type' => 'success'
        );

		session()->put('pesan',$pesan);

		return redirect()->back()->with('pesan', $pesan);
    }

    public function update_password(Request $req)
    {
        $id_user = $req->id_user_change;
        $password = $req->password;

        $user = User::find($id_user);
        $user->password = bcrypt($password);
        $user->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => "Password berhasil diperbaharui!",
            'alert-type' => 'success'
        );

		session()->put('pesan',$pesan);

		return redirect()->back()->with('pesan', $pesan);
    }
}
