<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Layanan;
use App\Models\HakAkses;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\LayananField;
use App\Models\Wisata;
use App\Models\WisataFoto;
use App\Models\WisataPaket;
use App\Models\WisataPaketFoto;
use Auth;
use DB;
use DataTables;

class WisataController extends Controller
{
    public function index()
    {
        // $data['provinsi'] = Provinsi::all();
        // $data['kabupaten'] = Kabupaten::all();
        return view('wisata.index');
    }

    public function get_data_provinsi(Request $request)
    {
        if ($request->ajax()) {

            $id_provinsi = request()->get('id_provinsi');

            if($id_provinsi == null)
            {
                if(Auth::user()->id_hak_akses == 1)
                    $data = Provinsi::all();   
                else     
                    $data = Provinsi::where('id', Auth::user()->id_provinsi)->get();  
            }
            else
            {
                $data = Provinsi::where('id', $id_provinsi)->get();   
            }   
        
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('nama_provinsi', function ($data) {
                        return $data->name;
                    })
                    ->addColumn('jumlah_layanan_aktif', function ($data) {
                        $jml = Wisata::where('id_provinsi', $data->id)
                                    ->where('is_aktif', 1)
                                    ->whereNull('id_kabupaten')
                                    ->count();
                        return $jml;
                    })
                    ->addColumn('status', function ($data) {
                        $jml = Wisata::where('id_provinsi', $data->id)
                                    ->where('is_aktif', 1)
                                    ->whereNull('id_kabupaten')
                                    ->count();

                        return ($jml > 0 ? "Aktif" : "Tidak Aktif");
                    })
                    ->addColumn('aksi', function ($data) {
                        return '<a href='.url('admin/wisata/index_detail?id_provinsi='.$data->id.'&type=prov').' title="Detail" class="btn btn-primary">Detail</a>';
                    })
                    ->make(true);
        }
    }

    public function get_data_kabupaten(Request $request)
    {
        if ($request->ajax()) {
            
            $id_kabupaten = request()->get('id_kabupaten');

            if($id_kabupaten == null)
            {                  
                if(Auth::user()->id_hak_akses == 1)
                    $data = Kabupaten::with('provinsi')->get();   
                else if(Auth::user()->id_hak_akses == 3)    
                    $data = Kabupaten::with('provinsi')->where('province_id', Auth::user()->id_provinsi)->get(); 
                else if(Auth::user()->id_hak_akses == 4)    
                    $data = Kabupaten::with('provinsi')->where('id', Auth::user()->id_kabupaten)->get();   
            }
            else
            {
                $data = Kabupaten::with('provinsi')->where('id', $id_kabupaten)->get();   
            }
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('nama_provinsi', function ($data) {
                        return $data->provinsi->name ?? '';
                    })
                    ->addColumn('nama_kabupaten', function ($data) {
                        return $data->name;
                    })
                    ->addColumn('jumlah_layanan_aktif', function ($data) {
                        $jml = Wisata::where('id_kabupaten', $data->id)
                                    ->where('is_aktif', 1)
                                    ->count();
                        return $jml;
                    })
                    ->addColumn('status', function ($data) {

                        $jml = Wisata::where('id_kabupaten', $data->id)
                                    ->where('is_aktif', 1)
                                    ->count();

                        return ($jml > 0 ? "Aktif" : "Tidak Aktif");
                    })
                    ->addColumn('aksi', function ($data) {
                        return '<a href='.url('admin/wisata/index_detail?id_provinsi='.$data->province_id.'&id_kabupaten='.$data->id.'&type=kab').' title="Detail" class="btn btn-primary">Detail</a>';
                    })
                    ->make(true);
        }
    }

    public function tambah()
    {
        $type = request()->get('type');
        $id_provinsi = request()->get('id_provinsi');
        $id_kabupaten = request()->get('id_kabupaten');

        $data['id'] = 0;
        $data['type'] = $type;
        $data['id_provinsi'] = $id_provinsi;
        $data['id_kabupaten'] = $id_kabupaten;
        $data['provinsi'] = Provinsi::find($id_provinsi);
        $data['kabupaten'] = Kabupaten::find($id_kabupaten);

        return view('wisata.tambah', $data);
    }

    public function edit($id)
    {
        $layanan = Wisata::find($id);
        $hotel_foto = WisataFoto::where('id_wisata', $id)->get();
        $kamar = WisataPaket::where('id_wisata', $id)->get();
        // $layanan_field = DB::table('layanan_fields')->where('id_layanan', $id)->where('tipe', '<>', 'File')->get();
        // $layanan_field_lampiran = DB::table('layanan_fields')->where('id_layanan', $id)->where('tipe', 'File')->get();
        $data['id'] = $id;
        $data['layanan'] = $layanan;
        $data['provinsi'] = Provinsi::find($layanan->id_provinsi);
        $data['kabupaten'] = Kabupaten::find($layanan->id_kabupaten);
        // $data['layanan_field'] = $layanan_field;
        // $data['layanan_field_lampiran'] = $layanan_field_lampiran;
        $data['type'] = $layanan->id_kabupaten == null ? 'prov' : 'kab';
        $data['id_provinsi'] = $layanan->id_provinsi;
        $data['id_kabupaten'] = $layanan->id_kabupaten;
        $data['hotel_foto'] = $hotel_foto;
        $data['kamar'] = $kamar;
        return view('wisata.tambah', $data);
    }

    public function simpan_update(Request $req)
    {
        $id = $req->id;

        if($id == 0)
            $layanan = new Wisata;
        else
            $layanan = Wisata::find($id);


        $layanan->nama = $req->nama;
        $layanan->is_aktif = $req->status;
        // $layanan->keterangan = $req->keterangan;
        $layanan->id_provinsi = $req->id_provinsi;
        $layanan->id_kabupaten = $req->id_kabupaten;
        // $layanan->lokasi_pengambilan = $req->lokasi_pengambilan;
        $layanan->tingkatan = $req->tingkatan;
        $layanan->tentang = $req->tentang;
        $layanan->alamat = $req->alamat;
        $layanan->latitude = $req->latitude;
        $layanan->longitude = $req->longitude;
        $layanan->no_rekening = $req->no_rekening;
        $layanan->fasilitas = $req->fasilitas;

        // if(Auth::user()->id_hak_akses == HakAkses::Admin)//Admin
        // {
        //     $layanan->id_provinsi = $req->id_provinsi;
        //     $layanan->id_kabupaten = $req->id_kabupaten;
        // }
        // else
        // {
        //     $layanan->id_provinsi = Auth::user()->id_provinsi;
        //     $layanan->id_kabupaten = Auth::user()->id_kabupaten;
        // }

        // if($req->image != null)
        // {
        //     $fileName = "layanan_".time().'.'.$req->image->extension();

        //     $req->image->move('layanan', $fileName);

        //     $layanan->image = $fileName;
        // }

        $layanan->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('admin/wisata/edit/'. $layanan->id)->with('pesan', $pesan);
    }

    public function get_modal_field($tipe)
    {
        $id = request()->get('id_wisata');
        if($tipe == "Gambar Wisata")
        {
            $modal = view('wisata.modal_gambar_wisata', compact('id'));
        }
        else
        {
            $id_paket = 0;
            $modal = view('wisata.modal_paket', compact('id','id_paket'));
        }

        return $modal;
    }

    public function simpan_detail(Request $req)
    {
        $field = new LayananField;
        $field->id_layanan = $req->id_layanan;
        $field->nama = $req->nama;
        $field->tipe = $req->tipe;
        $field->is_required = $req->is_required;

        if($req->tipe == "File")
        {
            $field->jenis_file = $req->jenis_file;
        }

        $field->save();

        if($req->tipe == "Dropdown")
        {
            $isi_dropdown = explode(",", $req->dropdown_value);

            foreach($isi_dropdown as $v)
            {
                $isi = [];
                $isi['id_layanan_field'] = $field->id;
                $isi['value'] = $v;

                DB::table('layanan_field_dropdown_values')->insert($isi);
            }
        }

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function hapus($id)
    {
        Wisata::find($id)->delete();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function index_detail()
    {
        $type = request()->get('type');
        $id_provinsi = request()->get('id_provinsi');
        $id_kabupaten = request()->get('id_kabupaten');
        
        if($type == 'prov')
            $layanan = Wisata::where('id_provinsi', $id_provinsi)->whereNull('id_kabupaten')->get();
        else
            $layanan = Wisata::where('id_kabupaten', $id_kabupaten)->get();

        $data['layanan'] = $layanan;
        $data['type'] = $type;
        $data['id_provinsi'] = $id_provinsi;
        $data['id_kabupaten'] = $id_kabupaten;

        return view('wisata.index_detail', $data);
    }

    public function simpan_gambar(Request $req)
    {
        try{
            $id_wisata = $req->id_wisata;
            $wisata = Wisata::find($id_wisata);
            $file = $req->file;
            for($i=0; $i < count($file); $i++)
            {
                if($file[$i] != null)
                {
                    $wisata_foto  = new WisataFoto;

                    $original_name = pathinfo($file[$i]->getClientOriginalName(), PATHINFO_FILENAME);
                    $fileName = "wisata_".$original_name."_".time().'.'.$file[$i]->extension();

                    $wisata_foto->nama = $original_name;
                    $wisata_foto->id_wisata = $id_wisata;
                    $wisata_foto->foto = $fileName;                

                    $file[$i]->move('gambar_wisata/'.$wisata->id, $fileName);

                    $wisata_foto->save();
                }
            }
            $data['status'] = 200;
            $data['message'] = "Upload gambar berhasil";
            return response()->json($data);
        }catch(\Exception $ex)
        {
            $data['status'] = 500;
            $data['message'] = $ex->getMessage();
            return response()->json($data);
        }
    }

    public function hapus_gambar($id)
    {
        WisataFoto::find($id)->delete();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil dihapus !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function simpan_paket(Request $req)
    {
        $id = $req->id;
        $id_wisata = $req->id_wisata;
        $nama = $req->nama;
        $harga = $req->harga;
        $jumlah_orang = $req->jumlah_orang;
        // $sqm = $req->sqm;
        $jumlah_tersedia = $req->jumlah_tersedia;
        $tanggal_tersedia_awal = $req->tanggal_tersedia_awal;
        $tanggal_tersedia_akhir = $req->tanggal_tersedia_akhir;
        $is_aktif = $req->is_aktif;
        $fasilitas = $req->fasilitas;
        // $tipe_bed = $req->tipe_bed;
        $about = $req->about;

        if($id == 0)
        {
            $paket = new WisataPaket;
        }
        else
        {
            $paket = WisataPaket::find($id);
        }

        $paket->nama = $nama;
        $paket->id_wisata = $id_wisata;
        $paket->harga = $harga;
        $paket->jumlah_orang = $jumlah_orang;
        $paket->jumlah_tersedia = $jumlah_tersedia;
        $paket->tanggal_tersedia_awal = $tanggal_tersedia_awal;
        $paket->tanggal_tersedia_akhir = $tanggal_tersedia_akhir;
        $paket->is_aktif = $is_aktif;
        $paket->fasilitas = $fasilitas;
        $paket->about = $about;
        $paket->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit_paket($id_paket)
    {
        $paket = WisataPaket::find($id_paket);
        // $id_paket = $id_kamar;
        $id = $paket->id_wisata;
        return view('wisata.modal_paket', compact('id','id_paket','paket'));
    }

    public function hapus_paket($id)
    {
        WisataPaket::find($id)->delete();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil dihapus !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function get_modal_foto_paket($id)
    {
        return view('wisata.modal_foto_paket', compact('id'));
    }

    public function simpan_gambar_paket(Request $req)
    {
        try{
            $id_paket = $req->id_paket;
            // $kamar = Room::find($id_kamar);
            $file = $req->file;
            for($i=0; $i < count($file); $i++)
            {
                if($file[$i] != null)
                {
                    $hotel_foto  = new WisataPaketFoto;

                    $original_name = pathinfo($file[$i]->getClientOriginalName(), PATHINFO_FILENAME);
                    $fileName = "paket_wisata_".$original_name."_".time().'.'.$file[$i]->extension();

                    $hotel_foto->nama = $original_name;
                    $hotel_foto->id_wisata_paket = $id_paket;
                    $hotel_foto->foto = $fileName;                

                    $file[$i]->move('gambar_paket/'.$id_paket, $fileName);

                    $hotel_foto->save();
                }
            }
            $data['status'] = 200;
            $data['message'] = "Upload gambar berhasil";
            return response()->json($data);
        }catch(\Exception $ex)
        {
            $data['status'] = 500;
            $data['message'] = $ex->getMessage();
            return response()->json($data);
        }
    }

    public function detail_paket($id)
    {
        $paket = WisataPaket::find($id);
        $foto_paket = WisataPaketFoto::where('id_wisata_paket',$id)->get();
        return view('wisata.detail_paket', compact('paket','foto_paket'));
    }

    public function hapus_foto_paket($id)
    {
        WisataPaketFoto::find($id)->delete();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil dihapus !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }
}
