<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PengajuanHaki extends Model
{
    use HasFactory;

    protected $table = 'pengajuan_haki';
    protected $guarded = [];

    public function jenis_haki()
    {
        return $this->belongsTo(JenisHaki::class, 'id_jenis_haki');
    }

    public static function no_reg() {

        $prefix = 'REG' . now()->format('Ymd');

        $last = self::where('kode_pengajuan', 'like', "{$prefix}%")
            ->latest('kode_pengajuan')
            ->first();

        $nextNumber = $last
            ? (int) substr($last->kode_pengajuan, strlen($prefix)) + 1
            : 1;

        return $prefix . str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
    }

    public function file_pendukung()
    {
        return $this->hasMany(PengajuanHakiFilePendukung::class, 'id_pengajuan_haki');
    }

    public function kolabolator()
    {
        return $this->hasMany(PengajuanHakiKolabolator::class, 'id_pengajuan_haki');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
    // public function materi()
    // {
    //     return $this->belongsTo(Materi::class, 'id_materi');
    // }
}
