@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Formulir</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Formulir</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Formulir</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Nama</th>
                <th>File</th>
                <th>Keterangan</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/master_formulir/get-data') }}",
        "columns": [
            { data: 'nama', name: 'nama' },
            { data: 'file', name: 'file' },
            { data: 'keterangan', name: 'keterangan' },
            // { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });
</script>
@endsection
