@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Hotel</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="{{ url('admin/hotel') }}">Hotel</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Hotel</h4>

    <div class="card-header-action">
        <a href="{{ url('admin/hotel') }}" class="btn btn-secondary">
          Kembali
        </a>
        <a href="{{ url('admin/hotel/tambah?id_provinsi='.$id_provinsi.'&id_kabupaten='.$id_kabupaten.'&type='.$type) }}" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <!-- <th>Kecamatan</th> -->
                <th>Nama</th>
                <th>Provinsi</th>
                <th>Kabupaten</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach($layanan as $val)
            <tr>
                <td>{{ $val->nama }}</td>
                <td>{{ $val->provinsi->name ?? "" }}</td>
                <td>{{ $val->kabupaten->name ?? "-" }}</td>
                <td>{!! ($val->is_aktif == 1 ? "<span class='badge badge-success'>Aktif</span>" : "<span class='badge badge-danger'>Tidak Aktif</span>") !!}</td>
                <td>
                    <a href="{{ url('admin/hotel/edit/'. $val->id) }}" title="Edit" class="btn btn-primary">Edit</a>
                    <a href="#" class="btn btn-danger text-white" onclick="hapus({{$val->id}})" title="Hapus">Hapus</a>
                </td>
            </tr>

            @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
    var table_data = $("#tblData").DataTable();

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = "{{ url('/admin/hotel/hapus') }}/"+id;
            }
        });
    }

</script>
@endsection
