@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">

@endsection

@section('isi')
<div class="section-header">
    <h1>Layanan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item active"><a href="#">Layanan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Layanan</h4>
  </div>
  <div class="card-body">
    <ul class="nav nav-tabs" id="myTab2" role="tablist">
      <li class="nav-item">
        <a class="nav-link active" id="home-tab2" data-toggle="tab" href="#home2" role="tab" aria-controls="home" aria-selected="true">Provinsi</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="profile-tab2" data-toggle="tab" href="#profile2" role="tab" aria-controls="profile" aria-selected="false">Kabupaten</a>
      </li>
    </ul>
    <div class="tab-content tab-bordered" id="myTab3Content">
      <div class="tab-pane fade show active" id="home2" role="tabpanel" aria-labelledby="home-tab2">

        <div class="form-group replyBox m-t-20">
          <label>Pilih Provinsi</label>
          <div class="row">
            <div class="col-md-6">
              <select class="form-control select2" name="id_provinsi" id="id_provinsi" style="width: 100%">
                <option value="">-- Silakan pilih --</option>
              </select>
            </div>   
            <div class="col-md-2">
              <button type="button" class="btn btn-secondary" onclick="reset_provinsi()"> Reset </button>
            </div>  
          </div>               
        </div>
        <div class="table-responsive">
          <table class="table table-striped table-hover" id="tblDataProvinsi" style="width:100%;">
            <thead>
              <tr>
                  <th>Provinsi</th>
                  <th>Jumlah Layanan Aktif</th>
                  <th>Status</th>
                  <th>Aksi</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
      <div class="tab-pane fade" id="profile2" role="tabpanel" aria-labelledby="profile-tab2">
        <div class="form-group replyBox m-t-20">
          <label>Pilih Daerah</label>
          <div class="row">
            <div class="col-md-6">
              <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" style="width: 100%">
                <option value="">-- Silakan pilih --</option>
              </select>
            </div>  
            <div class="col-md-2">
              <button type="button" class="btn btn-secondary" onclick="reset_kab()"> Reset </button>
            </div> 
          </div>
                   
        </div>
        <div class="table-responsive">
          <table class="table table-striped table-hover" id="tblData" style="width:100%;">
            <thead>
              <tr>
                  <th>Provinsi</th>
                  <th>Kabupaten</th>
                  <th>Jumlah Layanan Aktif</th>
                  <th>Status</th>
                  <th>Aksi</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>

<script>

    function generate_data_kab(id_kabupaten)
    {
      $("#tblData").DataTable({
          destroy: true,
          processing: true,
          serverSide: true,
          ajax: "{{ url('admin/master/layanan/get_data_kabupaten') }}?id_kabupaten="+id_kabupaten,
          "columns": [
              { data: 'nama_provinsi', name: 'nama_provinsi' },
              { data: 'nama_kabupaten', name: 'nama_kabupaten' },
              { data: 'jumlah_layanan_aktif', name: 'jumlah_layanan_aktif' },
              { data: 'status', name: 'status' },
              { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
          ]
      });
    }

    function generate_data_prov(id_provinsi)
    {
      $("#tblDataProvinsi").DataTable({
          destroy: true,
          processing: true,
          serverSide: true,
          ajax: "{{ url('admin/master/layanan/get_data_provinsi') }}?id_provinsi="+id_provinsi,
          "columns": [
              { data: 'nama_provinsi', name: 'nama_provinsi' },
              { data: 'jumlah_layanan_aktif', name: 'jumlah_layanan_aktif' },
              { data: 'status', name: 'status' },
              { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
          ]
      });
    }

    generate_data_prov($("#id_provinsi").val());
    generate_data_kab($("#id_kabupaten").val());

    $(document).ready(function() {
      $("#id_provinsi").select2({
          minimumInputLength: 2,
          // tags: [],
          multiple: false,
          ajax: {
              url: "{{ url('get_provinsi') }}",
              dataType: 'json',
              type: "GET",
              quietMillis: 50,
              data: function (term) {
                  return {
                      term: term
                  };
              },
              processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.name,
                              id: item.id
                          }
                      })
                  };
              }
          }
      });

      $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kabupaten') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
   
    $("#id_provinsi").on("change", function() {
      generate_data_prov($(this).val());
    });

    $("#id_kabupaten").on("change", function() {
      generate_data_kab($(this).val());
    });

    function reset_provinsi()
    {
      $("#id_provinsi").val("").trigger('change');
      generate_data_prov("");
    }

    function reset_kab()
    {
      $("#id_kabupaten").val("").trigger('change');
      generate_data_kab("");
    }

</script>
@endsection
