@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Modul & Materi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Modul & Materi</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Program : {{ $program->nama }}</h4>

    <div class="card-header-action">
        <a href="{{ url('admin/modul') }}" class="btn btn-warning text-white"> Kembali</a>
        @if (Auth::user()->id_hak_akses != 2)
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah Materi
        </button>
        @endif        
    </div>
    
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Materi</th>
                <th>Deskripsi</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                @php
                  $no = 1;
                @endphp
                @foreach ($materi as $item)
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{{ $item->nama }}</td>
                        <td>{{ $item->deskripsi }}</td>
                        <td>
                            @if (Auth::user()->id_hak_akses != 2)
                                <a href="{{ url('/admin/modul/lihat_modul/'.$item->id) }}" class="btn btn-success text-white" title="Tambah & Lihat Materi">Tambah & Lihat Modul</a>
                                <a href="javascript:;" data-toggle="modal" data-target="#modal-tambah" onclick="edit_materi({{$item->id}})" class="btn btn-primary text-white" title="Edit">Edit</a>
                                <a href="javascript:;" onclick="hapus_materi({{$item->id}})" class="btn btn-danger text-white" title=Hapus">Hapus</a>

                            @else
                            <a href="{{ url('/admin/modul/lihat_modul/'.$item->id) }}" class="btn btn-success text-white" title="Tambah & Lihat Materi">Lihat Modul</a>
                            @endif
                            
                        </td>
                    </tr>

                    @php
                        $no++;
                    @endphp
                @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Program</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/modul/tambah_materi')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama Materi</label> 
                                <input type="text" class="form-control" name="nama" id="nama" required maxlength="255"> 
                                <input type="hidden" class="form-control" name="id_materi" id="id_materi"> 
                                <input type="hidden" class="form-control" name="id_program" id="id_program" value="{{ $id_program }}"> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Deskripsi</label> 
                                <textarea name="deskripsi" class="form-control" id="deskripsi"></textarea>
                            </div> 
                        </div>
                    </div> 
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script>
    $("#tblData").DataTable();

    function edit_materi(id)
    {
        var url = "{{url('admin/modul/materi')}}/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_materi").val(data.id);
                $("#nama").val(data.nama);
                $("#deskripsi").val(data.deskripsi);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function hapus_materi(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/modul/hapus_materi') }}/"+id,
                    success: function(data){
                        swal({
                            title: "SUKSES",
                            text: "Data Terhapus!",
                            icon: "success"
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(data){
                        swal({
                            title: "GAGAL",
                            text: "Something went wrong!",
                            icon: "error"
                        });
                    }
                })
            }
        });
    }
</script>
@endsection