@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Pengajaran</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Pengajaran</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Pengajaran</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Program</th>
                <th>Pengajar</th>
                <th>Materi</th>
                <th>Jadwal</th>
                <th>Pukul</th>
                <th>Link Zoom</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Pengajaran</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/pengajaran/tambah')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Program</label>
                                <select name="id_program" class="form-control" id="id_program" onchange="cekMateri()" required>
                                    <option value="">-- Pilih Program --</option>
                                    @foreach($program as $v)
                                        <option value="{{$v->id}}">{{$v->nama}}</option>
                                    @endforeach
                                </select>
                                <input type="hidden" name="id_pengajaran" id="id_pengajaran">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Materi</label>
                                <select name="id_materi" class="form-control" id="id_materi"  required>
                                    <option value="">-- Pilih Materi --</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jadwal</label>
                                <input type="text" readonly name="tanggal" id="tanggal" class="form-control datepicker" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jam Mulai</label>
                                <input type="text" readonly name="jam_mulai" id="jam_mulai" value="{{date('H:i')}}" class="form-control timepicker" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jam Selesai</label>
                                <input type="text" readonly name="jam_selesai" id="jam_selesai" value="{{date('H:i')}}" class="form-control timepicker" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Link Zoom</label>
                                <input type="text" name="link_zoom" id="link_zoom" class="form-control" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js') }}"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/pengajaran/get-data') }}",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'nama_program', name: 'nama_program' },
            { data: 'pengajar', name: 'pengajar' },
            { data: 'nama_materi', name: 'nama_materi' },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'pukul', name: 'pukul' },
            { data: 'link_zoom', name: 'link_zoom' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "{{url('admin/pengajaran')}}/"+id+"/edit";
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_pengajaran").val(data.id);
                $("#id_program").val(data.id_program);
                $("#tanggal").val(data.tanggal);
                $("#jam_mulai").val(data.jam_mulai);
                $("#jam_selesai").val(data.jam_selesai);
                $("#link_zoom").val(data.link_zoom);

                cekMateri();

                $("#id_materi").val(data.id_materi);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_pengajaran").val("");
        $("#id_program").val("");
        $("#id_materi").val("");
        $("#tanggal").val("");
        $("#link_zoom").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/pengajaran') }}/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    function cekMateri()
    {
        var id_program = $("#id_program").val();
        $("#id_materi").empty();

        var option = "";
        $.ajax({
            type: "GET",
            url: "{{ url('admin/pengajaran/get_materi') }}/" + id_program,
            async: false,
            success: function(result)
            {
                $.each(result, function(i,l){

                    option += '<option value='+ l.id + '>'+l.nama+'</option>';

                });

                $("#id_materi").html(option);
            }
        })
    }
</script>
@endsection
