@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Sertifikat</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Sertifikat</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Sertifikat</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Nama Program</th>
                {{-- <th>Jadwal</th> --}}
                <th>Pengajar</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                @php
                  $no = 1;
                @endphp
                @foreach ($sertifikat as $item)
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{{ $item->program }}</td>
                        {{-- <td>{{ date('d-M-Y', strtotime($item->program->mulai)). " s.d ". date('d-M-Y', strtotime($item->program->selesai)) }}</td> --}}
                        <td>{{ $item->pengajar }}</td>
                        <td>
                            <a href="{{ url('/admin/sertifikat/lihat_peserta/'.$item->id_program) }}" class="btn btn-success text-white" title="Lihat Peserta">Lihat Peserta</a>
                        </td>
                    </tr>

                    @php
                        $no++;
                    @endphp
                @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')

@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script>
    $("#tblData").DataTable();
</script>
@endsection