@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Ujian</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Ujian</h4>

    <div class="card-header-action">
        @if (Auth::user()->id_hak_akses != 2)
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
        @endif
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th style="width: 12px">No</th>
                <th>Program</th>
                <th>Jadwal</th>
                <th>Pukul</th>
                <th>Durasi</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Ujian </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/ujian/tambah')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Program</label>
                                <select name="id_program" class="form-control" id="id_program" onchange="cekMateri()" required>
                                    <option value="">-- Pilih Program --</option>
                                    @foreach($program as $v)
                                        <option value="{{$v->id}}">{{$v->nama}}</option>
                                    @endforeach
                                </select>
                                <input type="hidden" name="id_ujian" id="id_ujian">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jadwal</label>
                                <input type="text" readonly name="tanggal" id="tanggal" class="form-control datepicker" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jam Mulai</label>
                                <input type="text" readonly name="jam_mulai" id="jam_mulai" class="form-control timepicker" value="{{date('H:i')}}" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jam Selesai</label>
                                <input type="text" readonly name="jam_selesai" id="jam_selesai" class="form-control timepicker" value="{{date('H:i')}}" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Poin Syarat Kelulusan</label>
                                <input type="number" name="syarat_kelulusan" id="syarat_kelulusan" class="form-control" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js') }}"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/ujian/get-data') }}",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'nama_program', name: 'nama_program' },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'pukul', name: 'pukul' },
            { data: 'duration', name: 'duration' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "{{url('admin/ujian')}}/"+id+"/edit";
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_ujian").val(data.id);
                $("#id_program").val(data.id_program);
                $("#tanggal").val(data.tanggal);
                $("#jam_mulai").val(data.jam_mulai);
                $("#jam_selesai").val(data.jam_selesai);
                $("#syarat_kelulusan").val(data.syarat_kelulusan);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_ujian").val("");
        $("#id_program").val("");
        $("#tanggal").val("");
        $("#syarat_kelulusan").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/ujian') }}/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

</script>
@endsection
