@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="{{ url('/admin/ujian') }}">Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Open</a></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
      <h4>Memulai Ujian</h4>
    </div>
    <div class="card-body">
        <div class="row">
            <label class="col-md-2">Nama Program</label>
            <div class="col-md-10">: {{ $ujian->program->nama ?? "N/A"}}</div>
        </div>
        <div class="row">
            <label class="col-md-2">Tanggal Ujian</label>
            <div class="col-md-10">: {{ date('d-M-Y', strtotime($ujian->tanggal)) }}</div>
        </div>
        <div class="row">
            <label class="col-md-2">Pukul</label>
            <div class="col-md-10">: {{ date('H:i', strtotime($ujian->jam_mulai)). " s.d ". date('H:i', strtotime($ujian->jam_selesai)) }}</div>
        </div>
        <div class="row">
            <label class="col-md-2">Durasi</label>
            <div class="col-md-10">: {{ SMUDESA::GetDurasi($ujian->tanggal,$ujian->jam_mulai,$ujian->jam_selesai) }}</div>
        </div>
        <div class="row">
            <label class="col-md-2">Skor Syarat Kelulusan</label>
            <div class="col-md-10">: {{ $ujian->syarat_kelulusan }}</div>
        </div>

        @if (
                date('Y-m-d H:i') >= date('Y-m-d H:i', strtotime($ujian->tanggal." ".$ujian->jam_mulai))
                &&
                date('Y-m-d H:i') <= date('Y-m-d H:i', strtotime($ujian->tanggal." ".$ujian->jam_selesai))
            )

            <div class="empty-state">
                <form id="fromMulaiUjian" method="POST" action="{{ url('admin/ujian/start')}}">
                    @csrf
                    <input type="hidden" value="{{ $ujian->id }}" name="id_ujian">
                    <input type="hidden" value="{{ $ujian->id_program }}" name="id_program">
                    <button type="button" onclick="StartUjian()" class="btn btn-success mt-4 btn-lg text-white">MULAI</button>
                </form>       
            </div>
        @else
            <div class="empty-state">       
                <button type="button" class="btn btn-success mt-4 btn-lg text-white" disabled>MULAI</button>
            </div>
        @endif
    </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script>

    function StartUjian()
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan memulai ujian!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $("#fromMulaiUjian").submit();
            }
        });
    }
    
</script>
@endsection