<?php

namespace App\Http\Controllers;

use App\Models\BidangTeknologi;
use Illuminate\Http\Request;
use DataTables;

class BidangTeknologiController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = BidangTeknologi::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('bidang_teknologi.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $nama       = $req->nama;

        if(!empty($id)) {

            $pengajar = BidangTeknologi::find($id);
            $pengajar->nama = $nama;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new BidangTeknologi;
            $pengajar->nama = $nama;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = BidangTeknologi::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        BidangTeknologi::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
