<?php

namespace App\Http\Controllers;

use App\Models\JenisPaten;
use Illuminate\Http\Request;
use DataTables;

class JenisPatenController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = JenisPaten::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('jenis_paten.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $nama       = $req->nama;

        if(!empty($id)) {

            $pengajar = JenisPaten::find($id);
            $pengajar->nama = $nama;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new JenisPaten;
            $pengajar->nama = $nama;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = JenisPaten::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        JenisPaten::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
