<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use DataTables;

class KabupatenKotaController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Kabupaten::with('provinsi')->get();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })        
                    ->make(true);
        }        
    }
    
    public function index()
    {
        $data['provinsi'] = Provinsi::all();
    	return view('kabupaten.index', $data);
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $province_id= $req->province_id;   
        $name       = $req->name;   
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Kabupaten::find($id);
            $pengajar->province_id = $province_id;
            $pengajar->name = $name;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Kabupaten;
            $pengajar->province_id = $province_id;
            $pengajar->name = $name;
            $pengajar->save();
            
            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }
        
        
        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Kabupaten::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Kabupaten::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
