<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pembayaran;
use App\Models\Program;
use DataTables;
use Carbon\Carbon;
use Auth;

class PembayaranController extends Controller
{
    public function index()
    {
        return view('pembayaran.index');
    }

    public function get_data(Request $request)
    {
        if ($request->ajax()) {

            if(Auth::user()->id_hak_akses == 2)
                $data = Pembayaran::select(['pembayarans.*','b.no_pendaftaran'])
                            ->join('pendaftaran_programs as b', 'pembayarans.id_pendaftaran_program','=','b.id')
                            ->where('b.id_user', Auth::user()->id)
                            ->get();
            else
                $data = Pembayaran::select(['pembayarans.*','b.no_pendaftaran'])
                            ->join('pendaftaran_programs as b', 'pembayarans.id_pendaftaran_program','=','b.id')
                            ->get();

            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('nama_program', function ($id) {

                        return $id->pendaftaran_program->program->nama ?? "-";
                    })
                    ->addColumn('harga_program', function ($id) {

                        return number_format($id->pendaftaran_program->program->harga ?? 0, 2);
                    })
                    ->addColumn('nama_peserta', function ($id) {

                        return $id->pendaftaran_program->user->name ?? "-";
                    })
                    ->addColumn('no_telp_peserta', function ($id) {

                        return $id->pendaftaran_program->user->no_telp ?? "-";
                    })
                    ->addColumn('kabupaten', function ($id) {

                        return $id->pendaftaran_program->user->kabupaten->name ?? "-";
                    })
                    ->addColumn('jadwal', function ($id) {

                        return date('d-M-Y', strtotime($id->pendaftaran_program->program->mulai)). " s.d " .date('d-M-Y', strtotime($id->pendaftaran_program->program->selesai));
                    })
                    ->editColumn('status', function ($id) {

                        if($id->status == "Telah Dibayar")
                        {
                            return '<div class="badge badge-success badge-shadow">'.$id->status.'</div>';
                        }
                        else
                        {
                            if($id->payment_status == null)
                                return '<div class="badge badge-warning badge-shadow">'.$id->status.'</div>';
                            else
                                return '<div class="badge badge-warning badge-shadow">'.$id->payment_status.'</div>';
                        }
                    })
                    ->addColumn('aksi', function ($id) {

                        if(Auth::user()->id_hak_akses == 1)
                        {
                            if($id->payment_status == null && $id->status == "Telah Dibayar")
                            {
                                return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-success" onclick="edit_data('.$id->id.');">Ubah Status</button>
                                    <a href="'.url('admin/pembayaran/detail/'.$id->id).'" class="btn btn-warning text-white" title="Detail Pembayaran">Detail</a>';
                            }
                            else
                            {
                                return '<a href="'.url('admin/pembayaran/detail/'.$id->id).'" class="btn btn-warning text-white" title="Detail Pembayaran">Detail</a>';
                            }

                        }
                        else
                        {
                            if($id->payment_status != null)
                            {
                                return '<button class="btn btn-success text-white" title="Detail Pembayaran" disabled>Verifikasi Pembayaran</button>';
                            }
                            else
                            {
                                return '<a href="'.url('admin/pembayaran/detail/'.$id->id).'" class="btn btn-success text-white" title="Verifikasi Pembayaran">Verifikasi Pembayaran</a>';
                            }

                        }


                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })
                    ->make(true);
        }

    }

    public function edit_status($id)
    {
        $data = Pembayaran::findOrfail($id);

        return response()->json($data);
    }

    public function ubah_status(Request $req)
    {
        $data = Pembayaran::findOrfail($req->id_pembayaran);

        if($req->status == "Belum Dibayar")
        {
            $data->status = $req->status;
            $data->updated_by = Auth::user()->id;
            $data->tanggal_pembayaran = null;
            $data->bukti_pembayaran = null;
            $data->save();
        }
        else if($req->status == "Telah Dibayar")
        {
            if($data->tanggal_pembayaran == null)
            {
                if($req->tanggal_pembayaran == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'Tanggal pembayaran tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);
                    return redirect()->back()->with('pesan', $pesan);
                }
            }

            if($data->bukti_pembayaran == null)
            {
                if($req->bukti_pembayaran == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'Bukti pembayaran tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);
                    return redirect()->back()->with('pesan', $pesan);
                }
            }

            $data->status = $req->status;
            $data->tanggal_pembayaran = $req->tanggal_pembayaran;
            $data->updated_by = Auth::user()->id;

            if($req->bukti_pembayaran != null)
            {
                $fileName = "Bukti Pembayaran_".$req->id_pembayaran."_".time().'.'.$req->bukti_pembayaran->extension();

                $req->bukti_pembayaran->move('bukti_pembayaran', $fileName);

                $data->bukti_pembayaran = $fileName;
            }

            $data->save();
        }


        $pesan = array(
            'header' => 'SUKSES',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);
        return redirect()->back()->with('pesan', $pesan);
    }

    public function detail($id_pembayaran)
    {
        $pembayaran =  Pembayaran::with('pendaftaran_program')->find($id_pembayaran);
        $data['pembayaran'] = $pembayaran;
        $data['program'] = Program::find($pembayaran->pendaftaran_program->id_program);
        return view('pembayaran.detail', $data);
    }
}
