<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PendaftaranProgram;
use App\Models\Program;
use App\Models\User;
use App\Models\Pembayaran;
use DataTables;
use Carbon\Carbon;
use Auth;
use App\Helpers\SMUDESA;

class PendaftaranProgramController extends Controller
{
    public function index()
    {
        $data['program'] = Program::where('status', 'Aktif')->get();
        $data['user'] = User::where('id_hak_akses', 2)->get();

        return view('pendaftaran_program.index', $data);
    }

    public function get_data(Request $request)
    {
        if ($request->ajax()) {

            $data = PendaftaranProgram::select(['pendaftaran_programs.*','p.nama as nama_program','u.name as nama_user','u.no_telp as no_telp_user'])
                            ->join('programs as p', 'pendaftaran_programs.id_program','=','p.id')
                            ->join('users as u', 'pendaftaran_programs.id_user','=','u.id')
                            ->get();

            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('jadwal', function ($id) {

                        return date('d-M-Y', strtotime($id->program->mulai)). " s.d " .date('d-M-Y', strtotime($id->program->selesai));
                    })
                    ->editColumn('status', function ($id) {

                        if($id->status == "Diterima")
                        {
                            return '<div class="badge badge-success badge-shadow">'.$id->status.'</div>';
                        }
                        else if($id->status == "Ditolak")
                        {
                            return '<div class="badge badge-danger badge-shadow">'.$id->status.'</div>';
                        }
                        else
                        {
                            return '<div class="badge badge-warning badge-shadow">'.$id->status.'</div>';
                        }
                    })
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit & Verifikasi</button>
                                <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';

                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })
                    ->make(true);
        }

    }

    public function tambah(Request $req)
    {
        $id_program = $req->id_program;
        $id_user = $req->id_user;
        $status = $req->status;

        $program = Program::find($id_program);

        //Edit Pendaftaran
        if($req->id_pendaftaran_program != null)
        {
            $new = PendaftaranProgram::find($req->id_pendaftaran_program);

            $eksis = PendaftaranProgram::where('id_program', $id_program)
                            ->where('id_user', $id_user)
                            ->where('id', '<>', $req->id_pendaftaran_program)
                            ->exists();

            if($eksis)
            {
                $pesan = array(
                    'header' => 'GAGAL',
                    'message' => 'Peserta sudah terdaftar diprogram tersebut !',
                    'alert-type' => 'error'
                );

                session()->put('pesan',$pesan);
                return redirect()->back()->with('pesan', $pesan);
            }
            else
            {
                $pembayaran = Pembayaran::where('id_pendaftaran_program', $req->id_pendaftaran_program)->first();

                // Edit Pembayaran
                if($pembayaran != null)
                {
                    if($pembayaran->status == "Telah Dibayar")
                    {
                        $pesan = array(
                            'header' => 'GAGAL',
                            'message' => 'Program ini telah dibayar oleh peserta, tidak bisa diubah !',
                            'alert-type' => 'error'
                        );

                        session()->put('pesan',$pesan);
                        return redirect()->back()->with('pesan', $pesan);
                    }
                    else
                    {
                        if($status == "Diterima")
                        {
                            $pembayaran->total_bayar = $program->harga;
                            $pembayaran->status = "Belum Dibayar";
                            $pembayaran->created_by = Auth::user()->id;
                            $pembayaran->save();

                            //Kirim Email ke Peserta
                            SMUDESA::SendEmail($new->user->email, "pendaftaran_diterima", $req->id_pendaftaran_program);
                        }
                        else
                        {
                            $pembayaran->delete();

                            if($status == "Ditolak")
                            {
                                //Kirim Email Penolakan
                                SMUDESA::SendEmail($new->user->email, "pendaftaran_ditolak", $req->id_pendaftaran_program);
                            }
                        }
                    }
                }
                else
                {
                    //Create Pembayaran
                    //Cek dulu jika status nya diterima
                    if($status == "Diterima")
                    {
                        $no_transaksi = Pembayaran::no_trx();

                        $pembayaran = new Pembayaran;
                        $pembayaran->id_pendaftaran_program = $req->id_pendaftaran_program;
                        $pembayaran->no_transaksi = $no_transaksi;
                        $pembayaran->total_bayar = $program->harga;
                        $pembayaran->created_by = Auth::user()->id;
                        $pembayaran->status = "Belum Dibayar";

                        $pembayaran->save();

                        //Kirim Email ke Peserta
                        SMUDESA::SendEmail($new->user->email, "pendaftaran_diterima", $req->id_pendaftaran_program);
                    }
                    else
                    {
                        if($status == "Ditolak")
                        {
                            //Kirim Email Penolakan
                            SMUDESA::SendEmail($new->user->email, "pendaftaran_ditolak", $req->id_pendaftaran_program);
                        }
                    }
                }

                $new->id_program = $id_program;
                $new->id_user = $id_user;
                $new->status = $status;
                $new->save();
            }
        }

        //Create Pendaftaran
        else
        {
            $eksis = PendaftaranProgram::where('id_program', $id_program)
                            ->where('id_user', $id_user)
                            ->exists();

            if($eksis)
            {
                $pesan = array(
                    'header' => 'GAGAL',
                    'message' => 'Peserta sudah terdaftar diprogram tersebut !',
                    'alert-type' => 'error'
                );

                session()->put('pesan',$pesan);
                return redirect()->back()->with('pesan', $pesan);
            }
            else
            {
                $no_pendaftaran = PendaftaranProgram::no_reg();

                $new = new PendaftaranProgram;
                $new->no_pendaftaran = $no_pendaftaran;
                $new->id_program = $id_program;
                $new->id_user = $id_user;
                $new->status = $status;
                $new->save();

                if($status == "Diterima")
                {
                    $no_transaksi = Pembayaran::no_trx();

                    $pembayaran = new Pembayaran;
                    $pembayaran->id_pendaftaran_program = $new->id;
                    $pembayaran->no_transaksi = $no_transaksi;
                    $pembayaran->total_bayar = $program->harga;
                    $pembayaran->created_by = Auth::user()->id;
                    $pembayaran->status = "Belum Dibayar";

                    $pembayaran->save();

                    //Kirim Email Ke Peserta
                    SMUDESA::SendEmail($new->user->email, "pendaftaran_diterima", $req->id_pendaftaran_program);
                }
                else
                {
                    if($status == "Ditolak")
                    {
                        //Kirim Email Penolakan
                        SMUDESA::SendEmail($new->user->email, "pendaftaran_ditolak", $req->id_pendaftaran_program);
                    }
                }
            }
        }

        $pesan = array(
            'header' => 'SUKSES',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);
        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit($id)
    {
        $data = PendaftaranProgram::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        try {

            $data = PendaftaranProgram::find($id);

            $pembayaran = Pembayaran::where('no_pendaftaran', $data->no_pendaftaran)->first();

            if($pembayaran != null)
            {
                if($pembayaran->status == "Telah Dibayar")
                {
                    $msg = 'Program telah dibayar!, Tidak bisa dihapus';
                    return ['message' => $msg, 'success' => 0];
                }
            }

            $data->delete();

            $msg = 'Program berhasil dihapus';
            return ['message' => $msg, 'success' => 1];

        } catch (\Exception $e) {

            $msg = $e->getMessage();
            return ['message' => $msg, 'success' => 0];
        }
    }
}
