<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pengajar;
use DataTables;

class PengajarController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Pengajar::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })        
                    ->make(true);
        }        
    }
    
    public function index()
    {
    	return view('pengajar.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $nama       = $req->nama;
        $email      = $req->email;
        $jenis_kelamin  = $req->jenis_kelamin;
        $no_telp        = $req->no_telp;
        $alamat         = $req->alamat;     
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Pengajar::find($id);
            $pengajar->nama = $nama;
            $pengajar->email = $email;
            $pengajar->jenis_kelamin = $jenis_kelamin;
            $pengajar->no_telp = $no_telp;
            $pengajar->alamat = $alamat;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Pengajar;
            $pengajar->nama = $nama;
            $pengajar->email = $email;
            $pengajar->jenis_kelamin = $jenis_kelamin;
            $pengajar->no_telp = $no_telp;
            $pengajar->alamat = $alamat;
            $pengajar->save();
            
            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }
        
        
        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Pengajar::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Pengajar::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
