<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLayanan extends Model
{
    use HasFactory;

    // Permohonan
    // Proses
    // Selesai
    // Dikembalikan

    const Permohonan = "Permohonan";
    const MenungguKonfirmasi = "Menunggu Konfirmasi";
    const Proses = "Diproses";
    const Selesai = "Selesai";
    const Dikembalikan = "Dikembalikan";

    public function layanan()
    {
        return $this->belongsTo(Layanan::class, 'id_layanan');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }

    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'id_provinsi');
    }

    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'id_kabupaten');
    }

    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class, 'id_kecamatan');
    }

    public function kelurahan()
    {
        return $this->belongsTo(Kelurahan::class, 'id_kelurahan');
    }
}
