<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Aspek;
use DataTables;

class AspekController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Aspek::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('aspek.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $name       = $req->name;
        $persentase = str_replace(",",".",$req->persentase);
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Aspek::find($id);
            $pengajar->nama = $name;
            $pengajar->persentase = $persentase;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Aspek;
            $pengajar->nama = $name;
            $pengajar->persentase = $persentase;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Aspek::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Aspek::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
