<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Dukcapil;
use App\Models\Indikator;
use App\Models\IndikatorDukcapil;
use App\Models\IndeksDukcapil;
use App\Models\DokumenPendukung;
use App\Models\Agama;
use App\Models\JenisPekerjaan;
use App\Models\PendidikanTerakhir;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\Kecamatan;
use App\Models\Kelurahan;
use App\Models\User;
use DataTables;
use DB;
use App\Helpers\SMUDESA;
use Auth;
use App\Exports\DukcapilExport;
use Excel;
use App\Imports\DukcapilImport;
use Carbon\Carbon;

class DukcapilController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $id_hak_akses = Auth::user()->id_hak_akses;
            $id_provinsi = $request->id_provinsi;
            $id_kabupaten = $request->id_kabupaten;
            $status = $request->status;

            $data = Dukcapil::select(['dukcapils.*','p.name as provinsi','r.name as kabupaten','i.skor as skor'])
                        ->join('provinces as p', 'dukcapils.id_provinsi','=','p.id')
                        ->join('regencies as r', 'dukcapils.id_kabupaten','=','r.id')
                        ->leftJoin('indeks_dukcapil as i','dukcapils.id','=','i.id_dukcapil');

            if($id_hak_akses == 1)
            {
                $data = $data;
            }
            else if($id_hak_akses == 3)
            {
                $data = $data->where('dukcapils.id_provinsi', Auth::user()->id_provinsi);
            }
            else if($id_hak_akses == 4)
            {
                $data = $data->where('dukcapils.id_kabupaten', Auth::user()->id_kabupaten);
            }
            else if($id_hak_akses == 5)
            {
                $data = $data->where('dukcapils.id_kecamatan', Auth::user()->id_kecamatan);
            }
            else if($id_hak_akses == 2)
            {
                $data = $data->where('dukcapils.id_user', Auth::user()->id);
            }
            else
            {
                $data = $data;
            }

            if($id_provinsi != null)
            {
                $data = $data->where('dukcapils.id_provinsi', $id_provinsi);
            }

            if($id_kabupaten != null)
            {
                $data = $data->where('dukcapils.id_kabupaten', $id_kabupaten);
            }

            if($status != 0)
            {
                if($status == SMUDESA::SANGAT_MISKIN)
                {
                    $data = $data->where('i.skor','>',0)->where('i.skor','<=',1206);
                }
                else if($status == SMUDESA::MISKIN)
                {
                    $data = $data->where('i.skor','>',1206)->where('i.skor','<=',1411);
                }
                else if($status == SMUDESA::HAMPIR_MISKIN)
                {
                    $data = $data->where('i.skor','>',1411)->where('i.skor','<=',1511);
                }
                else if($status == SMUDESA::RENTAN_MISKIN)
                {
                    $data = $data->where('i.skor','>',1511)->where('i.skor','<=',1601);
                }
                else if($status == SMUDESA::TIDAK_MISKIN)
                {
                    $data = $data->where('i.skor','>',1601);
                }
                else if($status == SMUDESA::BELUM_INPUT_DATA)
                {
                    $data = $data->whereNull('i.skor');
                }
            }

            $data = $data->get();

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        // return '<a href="#" title="Edit" class="btn btn-primary btn-sm">Edit</a>
                        // <button class="btn btn-danger text-white btn-sm" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>
                        // <a href="#" title="Detail Indikator" class="btn btn-success text-white btn-sm">Detail Indikator</a>
                        // <a href="#" title="Layanan" class="btn btn-warning text-white btn-sm">Layanan</a>';

                        return '<div class="btn-group mb-2">
                            <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Aksi
                            </button>
                            <div class="dropdown-menu" style="will-change: transform;">
                                <a class="dropdown-item" href="'.url("dukcapil/edit/".$id->id).'">Edit</a>
                                <a class="dropdown-item" href="#" onclick="hapus('.$id->id.');">Hapus</a>
                                <a class="dropdown-item" href="'.url("dukcapil/detail_indikator/".$id->id).'">Detail Indikator</a>
                                <a class="dropdown-item" href="'.url("dukcapil/layanan/".$id->id).'">Layanan</a>
                            </div>
                        </div>';
                    })
                    ->addColumn('skor', function($id) {
                        $indeks = IndeksDukcapil::where('id_dukcapil', $id->id)->first();

                        if($indeks == null)
                            return "-";
                        else
                            return $indeks->skor;
                    })
                    ->addColumn('status', function($id) {
                        $indeks = IndeksDukcapil::where('id_dukcapil', $id->id)
                                        // ->where('tahun', $tahun)
                                        ->first();

                        if($indeks == null)
                        {
                            return SMUDESA::GetPredikat(null);
                        }
                        else{
                            return SMUDESA::GetPredikat($indeks->skor);
                        }
                    })
                    // ->setRowClass(function ($data) use($status) {

                    //     $indeks = IndeksDukcapil::where('id_dukcapil', $data->id)
                    //                     // ->where('tahun', $tahun)
                    //                     ->first();

                    //     if($indeks == null)
                    //     {
                    //         $predikat = SMUDESA::GetPredikatOnly(null);
                    //     }
                    //     else{
                    //         $predikat = SMUDESA::GetPredikatOnly($indeks->skor);
                    //     }

                    //     if($status == 0 || $status == $predikat)
                    //         return '';
                    //     else
                    //         return 'hidden';
                    // })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('dukcapil.index');
    }

    public function tambah()
    {
        $agama = Agama::all();
        $jenis_pekerjaan = JenisPekerjaan::all();
        $pendidikan_terakhir = PendidikanTerakhir::all();

        $data['agama'] = $agama;
        $data['jenis_pekerjaan'] = $jenis_pekerjaan;
        $data['pendidikan_terakhir'] = $pendidikan_terakhir;
        return view('dukcapil.tambah', $data);
    }

    public function simpan(Request $req)
    {
        $eksis = Dukcapil::where('nik', $req->nik)
                    ->where('id', '<>', $req->id)
                    ->exists();

        if($eksis)
        {
            $pesan['header'] = "Gagal";
            $pesan['message'] = "NIK sudah terdaftar";
            $pesan['alert-type'] = "error";

            return redirect('/dukcapil')->with('pesan', $pesan);
        }

        if($req->id == 0)
        {
            $dukcapil = new Dukcapil;
            $dukcapil->code = $req->nik.".".$req->no_kk;

            $user = new User;
            $user->nik = $req->nik;
            $user->no_kk = $req->no_kk;
            $user->name = $req->nama_lengkap;
            $user->email = $req->email;
            $user->password = bcrypt($req->nik);
            $user->id_hak_akses = 2;
            $user->is_aktif = 1;
            $user->id_provinsi = $req->id_provinsi;
            $user->id_kabupaten = $req->id_kabupaten;
            $user->id_kecamatan = $req->id_kecamatan;
            $user->save();

            $dukcapil->id_user = $user->id;
        }
        else
        {
            $dukcapil = Dukcapil::find($req->id);
        }

        $dukcapil->nik = $req->nik;
        $dukcapil->no_kk = $req->no_kk;
        $dukcapil->nama_lengkap = $req->nama_lengkap;
        $dukcapil->jenis_kelamin = $req->jenis_kelamin;
        $dukcapil->tempat_lahir = $req->tempat_lahir;
        $dukcapil->tanggal_lahir = $req->tanggal_lahir;
        $dukcapil->id_agama = $req->id_agama;
        $dukcapil->golongan_darah = $req->golongan_darah;
        $dukcapil->alamat_sekarang = $req->alamat_sekarang;
        $dukcapil->id_provinsi = $req->id_provinsi;
        $dukcapil->id_kabupaten = $req->id_kabupaten;
        $dukcapil->id_kecamatan = $req->id_kecamatan;
        $dukcapil->id_kelurahan = $req->id_kelurahan;
        $dukcapil->alamat_sebelumnya = $req->alamat_sebelumnya;
        $dukcapil->status_perkawinan = $req->status_perkawinan;
        $dukcapil->tanggal_perkawinan = $req->tanggal_perkawinan;
        $dukcapil->status_hub_keluarga = $req->status_hub_keluarga;
        $dukcapil->cacat_fisik_mental = $req->cacat_fisik_mental;
        $dukcapil->id_pendidikan_terakhir = $req->id_pendidikan_terakhir;
        $dukcapil->id_jenis_pekerjaan = $req->id_jenis_pekerjaan;
        $dukcapil->nik_ibu = $req->nik_ibu;
        $dukcapil->nama_ibu = $req->nama_ibu;
        $dukcapil->nik_ayah = $req->nik_ayah;
        $dukcapil->nama_ayah = $req->nama_ayah;
        $dukcapil->kepemilikan_akta_lahir = $req->kepemilikan_akta_lahir;
        $dukcapil->nomor_akta_lahir = $req->nomor_akta_lahir;
        $dukcapil->kepemilikan_akta_kawin = $req->kepemilikan_akta_kawin;
        $dukcapil->nomor_akta_kawin = $req->nomor_akta_kawin;
        $dukcapil->kepemilikan_akta_cerai = $req->kepemilikan_akta_cerai;
        $dukcapil->nomor_akta_cerai = $req->nomor_akta_cerai;
        $dukcapil->tanggal_cerai = $req->tanggal_cerai;
        $dukcapil->latitude = $req->latitude;
        $dukcapil->longitude = $req->longitude;
        $dukcapil->email = $req->email;

        if($req->foto != null)
        {
            $nama_file = "foto_".time().'.'.$req->foto->extension();

            $req->foto->move('foto_dukcapil', $nama_file);
            $dukcapil->foto = $nama_file;
        }

        $dukcapil->save();

        $pesan['header'] = "Sukses";
        $pesan['message'] = "Data tersimpan";
        $pesan['alert-type'] = "success";

        if($req->sumber_dari == "profile")
            return redirect()->back()->with('pesan', $pesan);
        else
            return redirect('/dukcapil')->with('pesan', $pesan);
    }

    public function edit($id)
    {
        $agama = Agama::all();
        $jenis_pekerjaan = JenisPekerjaan::all();
        $pendidikan_terakhir = PendidikanTerakhir::all();
        $dukcapil = Dukcapil::find($id);

        $data['dukcapil'] = $dukcapil;
        $data['provinsi'] = Provinsi::find($dukcapil->id_provinsi);
        $data['kabupaten'] = Kabupaten::find($dukcapil->id_kabupaten);
        $data['kecamatan'] = Kecamatan::find($dukcapil->id_kecamatan);
        $data['kelurahan'] = Kelurahan::find($dukcapil->id_kelurahan);
        $data['agama'] = $agama;
        $data['jenis_pekerjaan'] = $jenis_pekerjaan;
        $data['pendidikan_terakhir'] = $pendidikan_terakhir;
        return view('dukcapil.edit', $data);
    }

    public function hapus($id)
    {
        // Provinsi::find($id)->delete();

        // $data['message'] = 'Data berhasil dihapus';
        // $data['issuccess'] = true;
        // return response()->json($data, 200);
    }

    public function detail_indikator($id)
    {
        $dukcapil = Dukcapil::find($id);

        $indikator = Indikator::select(['indikators.*','v.nama as variabel'])
                            ->join('variabels as v','indikators.id_variabel','=','v.id')
                            ->orderBy('v.id', 'asc')
                            ->orderBy('indikators.id', 'asc')
                            ->get();

        $indikator_dukcapil = IndikatorDukcapil::where('id_dukcapil', $id)
                            ->get();
        $indeks_dukcapil = IndeksDukcapil::where('id_dukcapil', $id)
                            ->first();

        $data['dukcapil'] = $dukcapil;
        $data['indikator'] = $indikator;
        $data['indikator_dukcapil'] = $indikator_dukcapil;
        $data['indeks_dukcapil'] = $indeks_dukcapil;
        $data['detail_dukcapil'] = view('dukcapil._detail_dukcapil', $data)->render();

        return view('dukcapil.detail_indikator', $data);
    }

    public function get_parameter()
    {
        // $tahun = request()->get('tahun');
        $id_dukcapil = request()->get('id_dukcapil');
        $id_indikator = request()->get('id_indikator');
        $indikator = Indikator::where('id', $id_indikator)->first();
        $isi = IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                    ->where('id_indikator', $id_indikator)
                    // ->where('tahun', $tahun)
                    ->first();

        if($indikator->jenis == "Pilihan")
        {
            if($isi != null)
            {
                $isi = $isi->parameter;
            }

            $html = '<label for="exampleInputEmail1" class="form-label">'.$indikator->nama.'</label>
                    <div class="mb-3">
                        <select class="form-control" name="pilihan" required>
                            <option>Choose...</option>';

            $parameter = DB::table('parameters')->where('id_indikator', $id_indikator)->get();

            foreach($parameter as $v)
            {
                $html .= '<option value="'.$v->id.'|'.$v->nilai.'|'.$v->nama.'" '.($isi == $v->nama ? "selected" : "").'>'.$v->nama.'</option>';
            }

            $html .= '</select></div>';

            return $html;
        }
        else if($indikator->jenis == "Kuantitas")
        {
            if($isi != null)
            {
                $isi = $isi->kuantitas;
            }
            $html = '<div class="mb-3">
                        <label class="form-label">'.$indikator->nama.'</label>
                        <input type="text" class="form-control allownumericwithdecimal" name="pilihan" value="'.$isi.'" required>
                    </div>';

            return $html;
        }
        else
        {
            if($isi != null)
            {
                $isi = $isi->kualitas;
            }

            $html = '<label for="exampleInputEmail1" class="form-label">'.$v->nama.'</label>
                    <textarea id="editor" class="form-control" name="pilihan">'.$isi.'</textarea>';

            return $html;
        }
    }

    public function simpan_parameter(Request $request)
    {
        $id_dukcapil = $request->id_dukcapil;
        $id_indikator = $request->indikator;
        $pilihan = $request->pilihan;
        // $tahun = $request->tahun;

        $indikator= Indikator::where('id', $id_indikator)->first();

        //Mandiri
        $cek_eksis = IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                        ->where('id_indikator', $id_indikator)
                        // ->where('tahun', $tahun)
                        ->exists();

        $is_upload = SMUDESA::IsUploadDataPendukung($id_indikator, $id_dukcapil);

        if($cek_eksis)
        {
            $nilai = 0;

            $updt = IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                                ->where('id_indikator', $id_indikator)
                                // ->where('tahun', $tahun)
                                ->first();

            if($indikator->jenis == "Pilihan")
            {
                $arr_pilihan = explode("|", $pilihan);
                if(count($arr_pilihan) == 1)
                {
                    IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                        ->where('id_indikator', $id_indikator)
                        // ->where('tahun', $tahun)
                        ->delete();
                }
                else
                {
                    $nilai = SMUDESA::GenerateNilai($id_dukcapil, $id_indikator, $arr_pilihan[1]);

                    $updt->nilai = $nilai;
                    $updt->id_parameter = $arr_pilihan[0];
                    $updt->parameter = $arr_pilihan[2];
                    $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
                    $updt->save();
                }

            }
            // else if($indikator->jenis == "Kuantitas")
            // {
            //     $pilihan = str_replace(",",".",$pilihan);
            //     $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $pilihan);

            //     $updt->nilai = $nilai;
            //     $updt->kuantitas = $pilihan;
            //     $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
            //     $updt->save();
            // }
            // else
            // {
            //     $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, 0);

            //     $updt->nilai = $nilai;
            //     $updt->kualitas = $pilihan;
            //     $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
            //     $updt->save();
            // }
        }
        else
        {
            $submit = new IndikatorDukcapil;
            $submit->id_indikator = $id_indikator;
            $submit->id_dukcapil = $id_dukcapil;
            // $submit->tahun = $tahun;
            $submit->is_upload_data_pendukung = ($is_upload ? 1 : 0);

            $nilai = 0;
            if($indikator->jenis == "Pilihan")
            {
                $arr_pilihan = explode("|", $pilihan);

                $nilai = SMUDESA::GenerateNilai($id_dukcapil, $id_indikator, $arr_pilihan[1]);

                $submit->id_parameter = $arr_pilihan[0];
                $submit->parameter = $arr_pilihan[2];
            }
            // else if($indikatorlokpri->jenis == "Kuantitas")
            // {
            //     $pilihan = str_replace(",",".",$pilihan);
            //     $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $pilihan);

            //     $submit->kuantitas = $pilihan;
            // }
            // else
            // {
            //     $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, 0);
            //     $submit->kualitas = $pilihan;
            // }

            $submit->nilai = $nilai;
            $submit->save();
        }

        SMUDESA::GenerateSkorIndeks($id_dukcapil);

        //Verifikator

        // $cek_eksis = IndikatorKabupatenVerifikator::where('id_kabupaten', $kabupaten)
        //                 ->where('id_indikator', $id_indikator)
        //                 ->where('tahun', $tahun)
        //                 ->exists();

        // $is_upload = SMUDESA::IsUploadDataPendukung($id_indikator, $kabupaten, $tahun);

        // if($cek_eksis)
        // {
        //     $nilai = 0;

        //     $updt = IndikatorKabupatenVerifikator::where('id_kabupaten', $kabupaten)
        //                         ->where('id_indikator', $id_indikator)
        //                         ->where('tahun', $tahun)
        //                         ->first();

        //     if($indikator->jenis == "Pilihan")
        //     {
        //         $arr_pilihan = explode("|", $pilihan);
        //         if(count($arr_pilihan) == 1)
        //         {
        //             IndikatorKabupatenVerifikator::where('id_kabupaten', $kabupaten)
        //                 ->where('id_indikator', $id_indikator)
        //                 ->where('tahun', $tahun)
        //                 ->delete();
        //         }
        //         else
        //         {
        //             $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $arr_pilihan[1]);

        //             $updt->nilai = $nilai;
        //             $updt->parameter = $arr_pilihan[0];
        //             $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
        //             $updt->save();
        //         }

        //     }
        //     else if($indikator->jenis == "Kuantitas")
        //     {
        //         $pilihan = str_replace(",",".",$pilihan);
        //         $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $pilihan);

        //         $updt->nilai = $nilai;
        //         $updt->kuantitas = $pilihan;
        //         $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
        //         $updt->save();
        //     }
        //     else
        //     {
        //         $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, 0);

        //         $updt->nilai = $nilai;
        //         $updt->kualitas = $pilihan;
        //         $updt->is_upload_data_pendukung = ($is_upload ? 1 : 0);
        //         $updt->save();
        //     }
        // }
        // else
        // {
        //     $submit = new IndikatorKabupatenVerifikator;
        //     $submit->id_indikator = $id_indikator;
        //     $submit->id_kabupaten = $kabupaten;
        //     $submit->tahun = $tahun;
        //     $submit->is_upload_data_pendukung = ($is_upload ? 1 : 0);

        //     $nilai = 0;
        //     if($indikator->jenis == "Pilihan")
        //     {
        //         $arr_pilihan = explode("|", $pilihan);

        //         $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $arr_pilihan[1]);

        //         $submit->parameter = $arr_pilihan[0];
        //     }
        //     else if($indikatorlokpri->jenis == "Kuantitas")
        //     {
        //         $pilihan = str_replace(",",".",$pilihan);
        //         $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, $pilihan);

        //         $submit->kuantitas = $pilihan;
        //     }
        //     else
        //     {
        //         $nilai = SMUDESA::GenerateNilai($kabupaten, $id_indikator, 0);
        //         $submit->kualitas = $pilihan;
        //     }

        //     $submit->nilai = $nilai;
        //     $submit->save();
        // }

        // SMUDESA::GenerateSkorIndeksVerifikator($kabupaten, $tahun);

        $pesan['header'] = "Sukses";
        $pesan['message'] = "Data tersimpan";
        $pesan['alert-type'] = "success";

        return redirect()->back()->with('pesan', $pesan);
    }

    public function dokumen_pendukung()
    {
        $id_indikator = request()->get('id_indikator');
        $id_dukcapil = request()->get('id_dukcapil');
        $indikator = Indikator::where('id', $id_indikator)->first();
        $dokumen = DB::table('dokumen_pendukung')
            ->where('id_indikator', '=', $id_indikator)
            ->where('id_dukcapil', '=', $id_dukcapil)
            // ->where('tahun', '=', $tahun)
            ->get();

        $indeks_dukcapil = IndeksDukcapil::where('id_dukcapil', $id_dukcapil)
            // ->where('tahun', $tahun)
            ->first();

        $dukcapil = Dukcapil::where('id', $id_dukcapil)->first();
        $redirect = request()->get('redirect');
        return view('dukcapil.dokumen_pendukung', compact('indikator', 'dokumen', 'dukcapil','indeks_dukcapil','redirect'));
    }

    public function simpan_dokumen_pendukung(Request $request)
    {
        if(empty($request->id))
        {
            $dokumen = new DokumenPendukung;
            $dokumen->id_indikator = $request->id_indikator;
            $dokumen->id_dukcapil = $request->id_dukcapil;
            $dokumen->nomor = $request->nomor;
            $dokumen->tanggal = $request->tanggal;
            $dokumen->tentang = $request->tentang;
            $dokumen->dokumen = $request->dokumen->store('public/dokumen');
            // $dokumen->tahun = $request->tahun;

            $dokumen->save();

            IndikatorDukcapil::where('id_dukcapil', $request->id_dukcapil)
                ->where('id_indikator', $request->id_indikator)
                // ->where('tahun',$request->tahun)
                ->update([
                    "is_upload_data_pendukung" => 1
                ]);
            // IndikatorKabupatenVerifikator::where('id_kabupaten', $request->id_kabupaten)
            //     ->where('id_indikator', $request->id_indikator)
            //     ->where('tahun',$request->tahun)
            //     ->update([
            //         "is_upload_data_pendukung" => 1
            //     ]);

            SMUDESA::GenerateSkorIndeks($request->id_dukcapil);
            // SMUDESA::GenerateSkorIndeksVerifikator($request->id_kabupaten, $request->tahun);
        }
        else
        {
            $dokumen = DokumenPendukung::find($request->id);
            $dokumen->nomor = $request->nomor;
            $dokumen->tanggal = $request->tanggal;
            $dokumen->tentang = $request->tentang;

            if($request->file('dokumen'))
            {
                $dokumen->dokumen = $request->dokumen->store('public/dokumen');
            }

            $dokumen->save();
        }

        $pesan['header'] = "Sukses";
        $pesan['message'] = "Data tersimpan";
        $pesan['alert-type'] = "success";

        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit_dokumen_pendukung($id)
    {
        $data = DokumenPendukung::find($id);

        return response()->json($data);
    }

    public function download_dokumen_pendukung($id)
    {
        $dokumen = DokumenPendukung::where('id', $id)->first();
        $path = storage_path('app/' . $dokumen->dokumen);
        return response()->file($path);
    }

    public function hapus_dokumen_pendukung($id)
    {
        $dok = DokumenPendukung::where('id', $id)->first();

        $id_dukcapil = $dok->id_dukcapil;
        $id_indikator = $dok->id_indikator;
        // $tahun = $dok->tahun;

        DokumenPendukung::find($id)->delete();

        $is_upload = SMUDESA::IsUploadDataPendukung($id_indikator, $id_dukcapil);

        IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                ->where('id_indikator', $id_indikator)
                // ->where('tahun',$tahun)
                ->update([
                    "is_upload_data_pendukung" => ($is_upload == true ? 1 : 0)
                ]);
        // IndikatorKabupatenVerifikator::where('id_kabupaten', $id_kabupaten)
        //         ->where('id_indikator', $id_indikator)
        //         ->where('tahun',$tahun)
        //         ->update([
        //             "is_upload_data_pendukung" => ($is_upload == true ? 1 : 0)
        //         ]);

        SMUDESA::GenerateSkorIndeks($id_dukcapil);
        // SMUDESA::GenerateSkorIndeksVerifikator($id_kabupaten, $tahun);

        $pesan['header'] = "Sukses";
        $pesan['message'] = "Data terhapus";
        $pesan['alert-type'] = "success";

        return redirect()->back()->with('pesan', $pesan);
    }

    public function layanan($id_dukcapil)
    {
        $dukcapil = Dukcapil::find($id_dukcapil);

        $data['dukcapil'] = $dukcapil;
        $data['detail_dukcapil'] = view('dukcapil._detail_dukcapil', compact('dukcapil',$dukcapil))->render();

        return view('dukcapil.layanan', $data);
    }

    public function export(Request $request)
    {
        $id_provinsi = $request->id_provinsi;
        $id_kabupaten = $request->id_kabupaten;
        $status = $request->status;

        return Excel::download(new DukcapilExport($id_provinsi, $id_kabupaten, $status), 'indikator.xlsx');
    }

    public function import(Request $request)
    {
        set_time_limit(0);

        $file = $request->file;
        $collection = Excel::toCollection(new DukcapilImport, $file);
        
        //validasi
        foreach($collection as $key => $val)
        {
            $kecamatan = Kecamatan::where('name', $val[$key]['kecamatan'])->first();

            if($kecamatan == null)
            {
                $pesan['header'] = "Peringatan";
                $pesan['message'] = "Kecamatan ".$val[$key]['kecamatan']." tidak ditemukan!";
                $pesan['alert-type'] = "error";

                return redirect('/dukcapil')->with('pesan', $pesan);
            }

            $kelurahan = Kelurahan::where('name', $val[$key]['kelurahan'])->where('district_id', ($kecamatan == null ? 0 : $kecamatan->id))->first();

            if($kelurahan == null)
            {
                $pesan['header'] = "Peringatan";
                $pesan['message'] = "Kelurahan ".$val[$key]['kelurahan']." tidak ditemukan!";
                $pesan['alert-type'] = "error";

                return redirect('/dukcapil')->with('pesan', $pesan);
            }

            $kabupaten = Kabupaten::where('id', ($kecamatan == null ? 0 : $kecamatan->regency_id))->first();

            $user = User::where('email', $val[$key]['email'])->first();

            if($user != null)
            {
                $pesan['header'] = "Peringatan";
                $pesan['message'] = "Email ".$val[$key]['email']." sudah terdaftar";
                $pesan['alert-type'] = "error";

                return redirect('/dukcapil')->with('pesan', $pesan);
            }

            try {
                Carbon::parse($val[$key]['tanggal_lahir_yyyy_mm_dd']);
            } catch (\Exception $e) {
                $pesan['header'] = "Peringatan";
                $pesan['message'] = "Invalid format tanggal lahir, format tanggal harus : yyyy-mm-dd. Contoh : 2023-12-31";
                $pesan['alert-type'] = "error";

                return redirect('/dukcapil')->with('pesan', $pesan);
            }
        }

        //insert
        foreach($collection as $key => $val)
        {
            $kecamatan = Kecamatan::where('name', $val[$key]['kecamatan'])->first();
            $kelurahan = Kelurahan::where('name', $val[$key]['kelurahan'])->where('district_id', ($kecamatan == null ? 0 : $kecamatan->id))->first();
            $kabupaten = Kabupaten::where('id', ($kecamatan == null ? 0 : $kecamatan->regency_id))->first();

            $dukcapil = new Dukcapil;
            $dukcapil->code = $val[$key]['nik'].".".$val[$key]['no_kk'];

            $user = new User;
            $user->nik = $val[$key]['nik'];
            $user->no_kk = $val[$key]['no_kk'];
            $user->name = $val[$key]['nama_lengkap'];
            $user->email = $val[$key]['email'];
            $user->password = bcrypt($val[$key]['nik']);
            $user->id_hak_akses = 2;
            $user->is_aktif = 1;
            $user->id_provinsi = $kabupaten == null ? 0 : $kabupaten->province_id;
            $user->id_kabupaten = $kabupaten == null ? 0 : $kabupaten->id;
            $user->id_kecamatan = $kecamatan == null ? 0 : $kecamatan->id;
            $user->save();

            $dukcapil->id_user = $user->id;

            $dukcapil->nik = $val[$key]['nik'];
            $dukcapil->no_kk = $val[$key]['no_kk'];
            $dukcapil->nama_lengkap = $val[$key]['nama_lengkap'];
            $dukcapil->jenis_kelamin = $val[$key]['jenis_kelamin_laki_lakiperempuan'];
            $dukcapil->tempat_lahir = $val[$key]['tempat_lahir'];
            $dukcapil->tanggal_lahir = $val[$key]['tanggal_lahir_yyyy_mm_dd'];
            $dukcapil->alamat_sekarang = $val[$key]['alamat'];
            $dukcapil->id_provinsi = $kabupaten == null ? 0 : $kabupaten->province_id;
            $dukcapil->id_kabupaten = $kabupaten == null ? 0 : $kabupaten->id;
            $dukcapil->id_kecamatan = $kecamatan == null ? 0 : $kecamatan->id;
            $dukcapil->id_kelurahan = $kelurahan == null ? 0 : $kelurahan->id;
            
            $dukcapil->latitude = $val[$key]['latitude'];
            $dukcapil->longitude = $val[$key]['longitude'];
            $dukcapil->email = $val[$key]['email'];

            $dukcapil->save();
        }

        $pesan['header'] = "Sukses";
        $pesan['message'] = "Data tersimpan";
        $pesan['alert-type'] = "success";

        return redirect('/dukcapil')->with('pesan', $pesan);            
    }
}
