<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Hotel;
use App\Models\Wisata;
use App\Models\WisataPaket;
use App\Models\Room;
use App\Models\HotelFoto;
use App\Models\RoomFoto;
use App\Models\WisataPaketFoto;

class FrontEndController extends Controller
{
    public function index()
    {
        // return view('front_end.landing.index_new');
        return view('front_end_new.index');
    }

    public function index_hotel()
    {
        $hotel = Hotel::where('is_aktif', 1)->paginate();

        $data['hotel'] = $hotel;
        return view('front_end.hotel.index', $data);
    }

    public function index_wisata()
    {
        $wisata = Wisata::where('is_aktif', 1)->paginate();

        $data['wisata'] = $wisata;
        return view('front_end.wisata.index', $data);
    }

    public function detail_hotel($id_hotel)
    {
        $hotel = Hotel::find($id_hotel);
        $hotel_foto = HotelFoto::where('id_hotel',$id_hotel)->get();
        $room = Room::where('id_hotel', $id_hotel)->get();

        $data['hotel'] = $hotel;
        $data['room'] = $room;
        $data['hotel_foto'] = $hotel_foto;

        return view('front_end.hotel.detail_new', $data);
    }

    public function detail_wisata($id_wisata)
    {
        $wisata = Wisata::find($id_wisata);
        $paket = WisataPaket::where('id_wisata', $id_wisata)->get();

        $data['wisata'] = $wisata;
        $data['paket'] = $paket;

        return view('front_end.wisata.detail', $data);
    }

    public function booking_room($id_room)
    {
        $room = Room::where('id', $id_room)->first();
        $room_foto = RoomFoto::where('id_room', $id_room)->get();

        $data['room'] = $room;
        $data['room_foto'] = $room_foto;
        return view('front_end.hotel.booking_room', $data);
    }

    public function booking_wisata($id_paket)
    {
        $paket = WisataPaket::where('id', $id_paket)->first();
        $paket_foto = WisataPaketFoto::where('id_wisata_paket', $id_paket)->get();

        $data['paket'] = $paket;
        $data['paket_foto'] = $paket_foto;
        return view('front_end.wisata.booking_wisata', $data);
    }
}
