<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Indikator;
use App\Models\Variabel;
use App\Models\Profil;
use Carbon\Carbon;
use DataTables;
use DB;

class IndikatorController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Indikator::select(['indikators.*','v.nama as variabel'])
                        ->join('variabels as v','indikators.id_variabel','=','v.id')
                        //->join('dimensis as a','v.id_dimensi','=','a.id')
                        // ->join('aspeks as b','v.id_aspek','=','b.id')
                        ->orderBy('indikators.id','ASC')
                        ->get();

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary btn-sm" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white btn-sm" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>
                        <a href="'.url('/admin/indikator/parameter/'.$id->id).'" class="btn btn-success text-white btn-sm" title="Parameter">Parameter</a>';
                    })
                    ->editColumn('label_surat', function ($id) {

                        if($id->label_surat == 1)
                        {
                            return "Ya";
                        }
                        else
                        {
                            return "Tidak";
                        }
                    })
                    ->make(true);
        }
    }

    public function index()
    {
        $data['variabel'] = Variabel::all();
        $data['profil'] = Profil::all();
    	return view('indikator.index', $data);
    }

    public function tambah(Request $request)
    {
        if($request->id == null)
        {
            $indikator = new Indikator;

            if ($request->jenis == "Pilihan") { // Pilihan

                // if($request->param1 == null || $request->param2 == null ||
                //     $request->param3 == null || $request->param4 == null)
                // {
                //     $data['message'] = 'Parameter tidak boleh kosong!';
                //     $data['issuccess'] = false;
                //     return response()->json($data, 200);
                // }

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                // $indikator->type = $request->type;
                // $indikator->label_surat = $request->label_surat;

                $indikator->save();

                // for($i = 0; $i <= 3; $i++)
                // {
                //     $param = "param".($i+1);

                //     $arr_isi = [];
                //     $arr_isi['id_indikator'] = $indikator->id;
                //     $arr_isi['nama'] = $request->$param;
                //     $arr_isi['nilai'] = $i;
                //     $arr_isi['created_at'] = Carbon::now();
                //     DB::table('parameters')->insert($arr_isi);
                // }

            } elseif ($request->jenis == "Kuantitas") { //Kuantitatif

                if($request->rawalparam1 == null || $request->rawalparam2 == null ||
                    $request->rawalparam3 == null || $request->rawalparam4 == null )
                {
                    $data['message'] = 'Parameter tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                if($request->rakhirparam1 == null || $request->rakhirparam2 == null ||
                    $request->rakhirparam3 == null || $request->rakhirparam4 == null)
                {
                    $data['message'] = 'Parameter tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                if($request->id_profil == null)
                {
                    $data['message'] = 'Data Profil tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                $indikator->id_profil = $request->id_profil;
                $indikator->type = $request->type;
                $indikator->label_surat = $request->label_surat;

                $indikator->save();

                for($i = 0; $i <= 3; $i++)
                {
                    $paramAwal = "rawalparam".($i+1);
                    $paramAkhir = "rakhirparam".($i+1);

                    $arr_isi = [];
                    $arr_isi['id_indikator'] = $indikator->id;
                    $arr_isi['range_start'] = str_replace(",",".",$request->$paramAwal);
                    $arr_isi['range_end'] = str_replace(",",".",$request->$paramAkhir);
                    $arr_isi['nilai'] = $i;
                    $arr_isi['created_at'] = Carbon::now();
                    DB::table('parameter_ranges')->insert($arr_isi);
                }

            } else { // Kualitas

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                $indikator->type = $request->type;
                $indikator->label_surat = $request->label_surat;
                $indikator->save();
            }

            $data['message'] = 'Indikator berhasil ditambahkan';
            $data['issuccess'] = true;
            return response()->json($data, 200);
        }
        else
        {
            $indikator = Indikator::where('id', $request->id)->first();
            if ($request->jenis == "Pilihan") { // Pilihan

                // if($request->param1 == null || $request->param2 == null ||
                //     $request->param3 == null || $request->param4 == null)
                // {
                //     $data['message'] = 'Parameter tidak boleh kosong!';
                //     $data['issuccess'] = false;
                //     return response()->json($data, 200);
                // }

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                // $indikator->type = $request->type;
                // $indikator->label_surat = $request->label_surat;

                $indikator->save();
                // DB::table('parameters')->where('id_indikator', $indikator->id)->delete();

                // for($i = 0; $i <= 3; $i++)
                // {
                //     $param = "param".($i+1);

                //     $arr_isi = [];
                //     $arr_isi['id_indikator'] = $indikator->id;
                //     $arr_isi['nama'] = $request->$param;
                //     $arr_isi['nilai'] = $i;
                //     $arr_isi['created_at'] = Carbon::now();
                //     DB::table('parameters')->insert($arr_isi);
                // }

            } elseif ($request->jenis == "Kuantitas") { //Kuantitatif

                if($request->rawalparam1 == null || $request->rawalparam2 == null ||
                    $request->rawalparam3 == null || $request->rawalparam4 == null)
                {
                    $data['message'] = 'Parameter tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                if($request->rakhirparam1 == null || $request->rakhirparam2 == null ||
                    $request->rakhirparam3 == null || $request->rakhirparam4 == null)
                {
                    $data['message'] = 'Parameter tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                if($request->id_profil == null)
                {
                    // return redirect()->back()->with('failed', 'Data Profil tidak boleh kosong!');
                    $data['message'] = 'Data Profil tidak boleh kosong!';
                    $data['issuccess'] = false;
                    return response()->json($data, 200);
                }

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                $indikator->id_profil = $request->id_profil;
                $indikator->type = $request->type;
                $indikator->label_surat = $request->label_surat;

                $indikator->save();
                DB::table('parameter_ranges')->where('id_indikator', $indikator->id)->delete();
                for($i = 0; $i <= 3; $i++)
                {
                    $paramAwal = "rawalparam".($i+1);
                    $paramAkhir = "rakhirparam".($i+1);

                    $arr_isi = [];
                    $arr_isi['id_indikator'] = $indikator->id;
                    $arr_isi['range_start'] = str_replace(",",".",$request->$paramAwal);
                    $arr_isi['range_end'] = str_replace(",",".",$request->$paramAkhir);
                    $arr_isi['nilai'] = $i;
                    $arr_isi['created_at'] = Carbon::now();
                    DB::table('parameter_ranges')->insert($arr_isi);
                }

            } else { // Kualitatif

                $indikator->id_variabel = $request->id_variabel;
                $indikator->nama = $request->name;
                $indikator->jenis = $request->jenis;
                $indikator->dokumen = $request->dokumen;
                $indikator->penjelasan = $request->penjelasan;
                $indikator->bobot = $request->bobot;
                $indikator->type = $request->type;
                $indikator->label_surat = $request->label_surat;
                $indikator->save();
            }

            $data['message'] = 'Indikator berhasil diubah';
            $data['issuccess'] = true;
            return response()->json($data, 200);
        }
    }

    public function edit($id)
    {
        $indikator = Indikator::where('id', $id)->first();
        $parameter = DB::table('parameters')->where('id_indikator', $id)->get();
        $parameter_range = DB::table('parameter_ranges')->where('id_indikator', $id)->get();

        $data['indikator'] = $indikator;
        $data['parameter'] = $parameter;
        $data['parameter_range'] = $parameter_range;

        return response()->json($data);
    }

    public function hapus($id)
    {
        $masterindikator = Indikator::find($id);
        $masterindikator->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    public function get_info_variabel($id_variabel)
    {
        $variabel = Variabel::find($id_variabel);
        $total_saat_ini = Indikator::where('id_variabel', $id_variabel)->sum('bobot');

        $data['persentase'] = $variabel->persentase;
        $data['total_saat_ini'] = $total_saat_ini;

        return response()->json($data);
    }

    public function parameter($id_indikator)
    {
        $data['id_indikator'] = $id_indikator;
        $data['parameter'] = DB::table('parameters')->where('id_indikator', $id_indikator)->get();
        return view('indikator.parameter', $data);
    }

    public function simpan_parameter(Request $req)
    {
        // dd($req->all());
        $id_indikator = $req->id_indikator;
        DB::table('parameters')->where('id_indikator', $id_indikator)->delete();

        foreach($req->parameter as $val)
        {
            $arr_isi = [];
            $arr_isi['id_indikator'] = $id_indikator;
            $arr_isi['nama'] = $val['parameter'];
            $arr_isi['nilai'] = $val['nilai'];
            $arr_isi['created_at'] = Carbon::now();
            DB::table('parameters')->insert($arr_isi);
        }

        $pesan = array(
    		'header' => 'Terima Kasih',
    	    'message' => 'Data berhasil disimpan !',
    	    'alert-type' => 'success'
    	);

    	session()->put('pesan',$pesan);

    	return redirect()->back()->with('pesan',$pesan);
    }
}
