<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use DataTables;
use App\Models\Kecamatan;
use App\Models\Kabupaten;

class KecamatanController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Kecamatan::join('regencies as b','districts.regency_id','=','b.id')->select(['districts.name as kecamatan','districts.id as id_kecamatan','b.name as kabupaten']);
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id_kecamatan.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id_kecamatan.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('kecamatan.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $regency_id= $req->regency_id;
        $name       = $req->name;
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Kecamatan::find($id);
            $pengajar->regency_id = $regency_id;
            $pengajar->name = $name;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Kecamatan;
            $pengajar->regency_id = $regency_id;
            $pengajar->name = $name;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Kecamatan::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Kecamatan::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
