<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use DataTables;
use App\Models\Kecamatan;
use App\Models\Kelurahan;

class KelurahanController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Kelurahan::with('kecamatan');
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('kelurahan.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $district_id= $req->district_id;
        $name       = $req->name;
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Kelurahan::find($id);
            $pengajar->district_id = $district_id;
            $pengajar->name = $name;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Kelurahan;
            $pengajar->district_id = $district_id;
            $pengajar->name = $name;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Kelurahan::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Kelurahan::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
