<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Layanan;
use App\Models\LayananField;
use App\Models\UserLayanan;
use App\Models\UserLayananDetail;
use Auth;
use DataTables;
use Illuminate\Support\Str;

class LayananController extends Controller
{
    public function index()
    {
        $layanan = Layanan::GetAktif()->paginate(12);
        
        $data['layanan'] = $layanan;
        return view('layanan.index', $data);
    }

    public function get_form($id_layanan)
    {
        $data['id'] = $id_layanan;
        $data['field_list'] = LayananField::where('id_layanan', $id_layanan)->where('tipe','<>','File')->get();
        $data['field_lampiran'] = LayananField::where('id_layanan', $id_layanan)->where('tipe','File')->get();
        $form = view("layanan.form", $data)->render();
        return $form;
    }

    public function daftar(Request $req)
    {
        // $eksis = UserLayanan::where('id_user', Auth::user()->id)
        //             ->where('id_layanan', $req->id_layanan)
        //             ->where('status', UserLayanan::Inprogress)
        //             ->exists();

        // if($eksis)
        // {
        //     $pesan = array(
        //         'header' => 'Gagal',
        //         'message' => 'Anda sudah terdaftar untuk layanan ini!',
        //         'alert-type' => 'warning'
        //     );

        //     session()->put('pesan',$pesan);

        //     return redirect()->back()->with('pesan', $pesan);
        // }
        // else
        // {

        // }
            // dd($req->all());
        $user_layanan = new UserLayanan;
        $user_layanan->no_layanan = strtoupper(Str::random(7));
        $user_layanan->kode = $req->nik."_".$req->no_kk;
        $user_layanan->nik = $req->nik;
        $user_layanan->no_kk = $req->no_kk;
        $user_layanan->nama_lengkap = $req->nama_lengkap;
        $user_layanan->id_provinsi = $req->id_provinsi;
        $user_layanan->id_kabupaten = $req->id_kabupaten;
        $user_layanan->id_kecamatan = $req->id_kecamatan;
        $user_layanan->id_kelurahan = $req->id_kelurahan;
        $user_layanan->id_user = Auth::user()->id;
        $user_layanan->id_layanan = $req->id_layanan;
        $user_layanan->status = UserLayanan::Permohonan;
        $user_layanan->save();

        $field = LayananField::where('id_layanan', $req->id_layanan)->get();

        foreach($field as $val)
        {
            $form_name = "field_".$val->id;
            $req_formname = $req->$form_name;
            if(!is_null($req_formname))
            {
                $detail = new UserLayananDetail;
                $detail->id_user_layanan = $user_layanan->id;
                $detail->id_layanan_field = $val->id;

                if($val->tipe == "File")
                {
                    if($req_formname != null)
                    {
                        $fileName = "user_layanan_".time().'.'.$req_formname->extension();

                        $req_formname->move('user_layanan', $fileName);

                        $detail->value = $fileName;
                    }
                }
                else
                {
                    $detail->value = $req_formname;
                }

                $detail->save();
            }
        }

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function status()
    {
        return view('layanan.status');
    }

    public function get_data_status(Request $request)
    {
        if ($request->ajax()) {

            $id_provinsi = $request->id_provinsi;
            $id_kabupaten = $request->id_kabupaten;
            $tab = $request->tab;

            $data = UserLayanan::select(['user_layanans.*','p.name as provinsi','r.name as kabupaten','l.nama as layanan','l.id_kabupaten as id_kabupaten_layanan'])
                        ->join('layanans as l','user_layanans.id_layanan','=','l.id')
                        ->join('provinces as p','user_layanans.id_provinsi','=','p.id')
                        ->join('regencies as r','user_layanans.id_kabupaten','=','r.id');

            if(Auth::user()->id_hak_akses == 1)
                $data = $data;
            else if(Auth::user()->id_hak_akses == 2)
                $data = $data->where('user_layanans.id_user', Auth::user()->id);
            else if(Auth::user()->id_hak_akses == 3)
                $data = $data->where('user_layanans.id_provinsi', Auth::user()->id_provinsi);
            else if(Auth::user()->id_hak_akses == 4)
                $data = $data->where('user_layanans.id_kabupaten', Auth::user()->id_kabupaten);
            else if(Auth::user()->id_hak_akses == 5)
                $data = $data->where('user_layanans.id_kecamatan', Auth::user()->id_kecamatan);

            if($id_provinsi != null)
            {
                $data = $data->where('user_layanans.id_provinsi', $id_provinsi);
            }

            if($id_kabupaten != null)
            {
                $data = $data->where('user_layanans.id_kabupaten', $id_kabupaten);
            }

            if($tab == "provinsi")
                $data = $data->whereNull('l.id_kabupaten');
            else
                $data = $data->whereNotNull('l.id_kabupaten');

            return Datatables::of($data->get())
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($data) {
                        $edit = "";

                        if($data->status == UserLayanan::Dikembalikan)
                        {
                            $edit = '<a href='.url("/layanans/status/edit/".$data->id).' title="Edit" class="btn btn-success text-white"><i class="fa fa-edit"></i></a>';
                        }

                        return $edit.' <a href='.url("/layanans/status/detail/".$data->id).' title="Detail" class="btn btn-primary"><i class="fa fa-eye"></i></a>
                        <button title="Hapus" class="btn btn-danger" onclick="hapus_data('.$data->id.')"><i class="fa fa-trash"></i></button>';
                    })
                    ->make(true);
        }
    }

    public function detail_status($id)
    {
        $user_layanan = UserLayanan::find($id);
        $user_layanan_detail = UserLayananDetail::select(['user_layanan_details.*','b.tipe','b.nama'])
                                ->join('layanan_fields as b','user_layanan_details.id_layanan_field','=','b.id')
                                ->where('id_user_layanan', $id)
                                ->get();

        $data['user_layanan'] = $user_layanan;
        $data['user_layanan_detail'] = $user_layanan_detail;
        return view('layanan.detail_status', $data);
    }

    public function update_status(Request $req)
    {
        $data = UserLayanan::find($req->id_user_layanan);
        $data->status = $req->status;

        if($req->file_upload != null)
        {
            $fileName = "file_upload_".time().'.'.$req->file_upload->extension();

            $req->file_upload->move('user_layanan', $fileName);

            $data->file_upload = $fileName;
        }

        $data->komentar = $req->komentar;
        $data->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('layanans/status')->with('pesan', $pesan);
    }

    public function hapus_status($id)
    {
        try{
            $data = UserLayanan::find($id)->delete();

            $result['message'] = 'Berhasil dihapus';
            return $result;
        }catch(\Exception $ex)
        {
            $result['message'] = $ex->getMessage();
            return $result;
        }
        
    }

    public function edit_status($id)
    {
        $user_layanan = UserLayanan::find($id);
        $user_layanan_detail = UserLayananDetail::select(['user_layanan_details.*','b.tipe','b.nama'])
                                ->join('layanan_fields as b','user_layanan_details.id_layanan_field','=','b.id')
                                ->where('id_user_layanan', $id)
                                ->get();

        $data['user_layanan'] = $user_layanan;
        $data['user_layanan_detail'] = $user_layanan_detail;
        return view('layanan.edit_status', $data);
    }

    public function revise_layanan(Request $req)
    {
        $user_layanan = UserLayanan::find($req->id_user_layanan);
        $user_layanan->nik = $req->nik;
        $user_layanan->no_kk = $req->no_kk;
        $user_layanan->nama_lengkap = $req->nama_lengkap;
        $user_layanan->id_provinsi = $req->id_provinsi;
        $user_layanan->id_kabupaten = $req->id_kabupaten;
        $user_layanan->id_kecamatan = $req->id_kecamatan;
        $user_layanan->id_kelurahan = $req->id_kelurahan;
        $user_layanan->status = UserLayanan::Permohonan;
        $user_layanan->save();

        $user_layanan_detail = UserLayananDetail::where('id_user_layanan', $req->id_user_layanan)->get();

        foreach($user_layanan_detail as $val)
        {
            $form_name = "field_".$val->id;
            $req_formname = $req->$form_name;

            if(!is_null($req_formname))
            {
                $detail = UserLayananDetail::find($val->id);

                if($detail != null)
                {
                    if($val->layanan_field->tipe == "File")
                    {
                        if($req_formname != null)
                        {
                            $fileName = "user_layanan_".time().'.'.$req_formname->extension();

                            $req_formname->move('user_layanan', $fileName);

                            $detail->value = $fileName;
                        }
                    }
                    else
                    {
                        $detail->value = $req_formname;
                    }

                    $detail->save();
                }
            }
        }

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil dikirim !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('layanans/status')->with('pesan', $pesan);
    }
}
