<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Layanan;
use App\Models\HakAkses;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\LayananField;
use Auth;
use DB;
use DataTables;

class MasterLayananController extends Controller
{
    public function index()
    {
        // $data['provinsi'] = Provinsi::all();
        // $data['kabupaten'] = Kabupaten::all();
        return view('master_layanan.index');
    }

    public function get_data_provinsi(Request $request)
    {
        if ($request->ajax()) {

            $id_provinsi = request()->get('id_provinsi');

            if($id_provinsi == null)
            {
                if(Auth::user()->id_hak_akses == 1)
                    $data = Provinsi::all();   
                else     
                    $data = Provinsi::where('id', Auth::user()->id_provinsi)->get();  
            }
            else
            {
                $data = Provinsi::where('id', $id_provinsi)->get();   
            }   
        
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('nama_provinsi', function ($data) {
                        return $data->name;
                    })
                    ->addColumn('jumlah_layanan_aktif', function ($data) {
                        $jml = Layanan::where('id_provinsi', $data->id)
                                    ->where('is_aktif', 1)
                                    ->whereNull('id_kabupaten')
                                    ->count();
                        return $jml;
                    })
                    ->addColumn('status', function ($data) {
                        $jml = Layanan::where('id_provinsi', $data->id)
                                    ->where('is_aktif', 1)
                                    ->whereNull('id_kabupaten')
                                    ->count();

                        return ($jml > 0 ? "Aktif" : "Tidak Aktif");
                    })
                    ->addColumn('aksi', function ($data) {
                        return '<a href='.url('admin/master/layanan/index_detail?id_provinsi='.$data->id.'&type=prov').' title="Detail" class="btn btn-primary">Detail</a>';
                    })
                    ->make(true);
        }
    }

    public function get_data_kabupaten(Request $request)
    {
        if ($request->ajax()) {
            
            $id_kabupaten = request()->get('id_kabupaten');

            if($id_kabupaten == null)
            {                  
                if(Auth::user()->id_hak_akses == 1)
                    $data = Kabupaten::with('provinsi')->get();   
                else if(Auth::user()->id_hak_akses == 3)    
                    $data = Kabupaten::with('provinsi')->where('province_id', Auth::user()->id_provinsi)->get(); 
                else if(Auth::user()->id_hak_akses == 4)    
                    $data = Kabupaten::with('provinsi')->where('id', Auth::user()->id_kabupaten)->get();   
            }
            else
            {
                $data = Kabupaten::with('provinsi')->where('id', $id_kabupaten)->get();   
            }
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('nama_provinsi', function ($data) {
                        return $data->provinsi->name ?? '';
                    })
                    ->addColumn('nama_kabupaten', function ($data) {
                        return $data->name;
                    })
                    ->addColumn('jumlah_layanan_aktif', function ($data) {
                        $jml = Layanan::where('id_kabupaten', $data->id)
                                    ->where('is_aktif', 1)
                                    ->count();
                        return $jml;
                    })
                    ->addColumn('status', function ($data) {

                        $jml = Layanan::where('id_kabupaten', $data->id)
                                    ->where('is_aktif', 1)
                                    ->count();

                        return ($jml > 0 ? "Aktif" : "Tidak Aktif");
                    })
                    ->addColumn('aksi', function ($data) {
                        return '<a href='.url('admin/master/layanan/index_detail?id_provinsi='.$data->province_id.'&id_kabupaten='.$data->id.'&type=kab').' title="Detail" class="btn btn-primary">Detail</a>';
                    })
                    ->make(true);
        }
    }

    public function tambah()
    {
        $type = request()->get('type');
        $id_provinsi = request()->get('id_provinsi');
        $id_kabupaten = request()->get('id_kabupaten');

        $data['id'] = 0;
        $data['type'] = $type;
        $data['id_provinsi'] = $id_provinsi;
        $data['id_kabupaten'] = $id_kabupaten;
        $data['provinsi'] = Provinsi::find($id_provinsi);
        $data['kabupaten'] = Kabupaten::find($id_kabupaten);

        return view('master_layanan.tambah', $data);
    }

    public function edit($id)
    {
        $layanan = Layanan::find($id);
        $layanan_field = DB::table('layanan_fields')->where('id_layanan', $id)->where('tipe', '<>', 'File')->get();
        $layanan_field_lampiran = DB::table('layanan_fields')->where('id_layanan', $id)->where('tipe', 'File')->get();
        $data['id'] = $id;
        $data['layanan'] = $layanan;
        $data['provinsi'] = Provinsi::find($layanan->id_provinsi);
        $data['kabupaten'] = Kabupaten::find($layanan->id_kabupaten);
        $data['layanan_field'] = $layanan_field;
        $data['layanan_field_lampiran'] = $layanan_field_lampiran;
        $data['type'] = $layanan->id_kabupaten == null ? 'prov' : 'kab';
        $data['id_provinsi'] = $layanan->id_provinsi;
        $data['id_kabupaten'] = $layanan->id_kabupaten;
        return view('master_layanan.tambah', $data);
    }

    public function simpan_update(Request $req)
    {
        $id = $req->id;

        if($id == 0)
            $layanan = new Layanan;
        else
            $layanan = Layanan::find($id);


        $layanan->nama = $req->nama;
        $layanan->is_aktif = $req->status;
        $layanan->keterangan = $req->keterangan;
        $layanan->id_provinsi = $req->id_provinsi;
        $layanan->id_kabupaten = $req->id_kabupaten;
        $layanan->lokasi_pengambilan = $req->lokasi_pengambilan;
        $layanan->tingkatan = $req->tingkatan;

        // if(Auth::user()->id_hak_akses == HakAkses::Admin)//Admin
        // {
        //     $layanan->id_provinsi = $req->id_provinsi;
        //     $layanan->id_kabupaten = $req->id_kabupaten;
        // }
        // else
        // {
        //     $layanan->id_provinsi = Auth::user()->id_provinsi;
        //     $layanan->id_kabupaten = Auth::user()->id_kabupaten;
        // }

        if($req->image != null)
        {
            $fileName = "layanan_".time().'.'.$req->image->extension();

            $req->image->move('layanan', $fileName);

            $layanan->image = $fileName;
        }

        $layanan->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('admin/master/layanan/edit/'. $layanan->id)->with('pesan', $pesan);
    }

    public function get_modal_field($tipe)
    {
        if($tipe == "LIST")
        {
            $modal = view('master_layanan.modal_jenis_list');
        }
        else
        {
            $modal = view('master_layanan.modal_lampiran');
        }

        return $modal;
    }

    public function simpan_detail(Request $req)
    {
        $field = new LayananField;
        $field->id_layanan = $req->id_layanan;
        $field->nama = $req->nama;
        $field->tipe = $req->tipe;
        $field->is_required = $req->is_required;

        if($req->tipe == "File")
        {
            $field->jenis_file = $req->jenis_file;
        }

        $field->save();

        if($req->tipe == "Dropdown")
        {
            $isi_dropdown = explode(",", $req->dropdown_value);

            foreach($isi_dropdown as $v)
            {
                $isi = [];
                $isi['id_layanan_field'] = $field->id;
                $isi['value'] = $v;

                DB::table('layanan_field_dropdown_values')->insert($isi);
            }
        }

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function hapus($id)
    {
        Layanan::find($id)->delete();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function index_detail()
    {
        $type = request()->get('type');
        $id_provinsi = request()->get('id_provinsi');
        $id_kabupaten = request()->get('id_kabupaten');
        
        if($type == 'prov')
            $layanan = Layanan::where('id_provinsi', $id_provinsi)->whereNull('id_kabupaten')->get();
        else
            $layanan = Layanan::where('id_kabupaten', $id_kabupaten)->get();

        $data['layanan'] = $layanan;
        $data['type'] = $type;
        $data['id_provinsi'] = $id_provinsi;
        $data['id_kabupaten'] = $id_kabupaten;

        return view('master_layanan.index_layanan', $data);
    }
}
