<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Menu;
use Carbon\Carbon;
use DB;
use DataTables;

class MenuController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Menu::all();
            return Datatables::of($data)
                    ->escapeColumns([])
                    // ->rawColumns(['aksi'])    
                    ->editColumn('induk', function($induk){
                        if($induk->id_induk == 0)
                        {
                            return 'Induk';
                        }else{
                            return $induk->childs_menu->menu ?? '';
                        }
                    })
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })        
                    ->make(true);
        }
        
    }
    
    public function index()
    {
    	$menu = Menu::all();
    	return view('menu.index', compact('menu'));
    }

    public function tambah(Request $req)
    {

        $id         = $req->id_menu;
        $id_induk   = $req->id_induk;
        $menu       = $req->menu;
        $icon       = $req->icon;
        $url        = $req->url;
        $no_urut    = $req->no_urut;     
        $pesan      = "";

        if(!empty($id)) {

            DB::table('menu')->where('id', $id)
                    ->update(
                        [
                            'id_induk' => $id_induk, 
                            'menu' => $menu, 
                            'icon' => $icon, 
                            'url' => $url, 
                            'no_urut' => $no_urut, 
                            'updated_at' => Carbon::now() 
                        ]);

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data Menu berhasil diubah !', 
                'alert-type' => 'success'
            );

        } else {

            $menus = new Menu;
            $menus->id_induk     = $id_induk;
            $menus->menu         = $menu;
            $menus->icon         = $icon;
            $menus->url          = $url;
            $menus->no_urut      = $no_urut;
            $menus->created_at   = Carbon::now();
            $menus->updated_at   = Carbon::now();
            $menus->save();
            
            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data Menu berhasil disimpan !', 
                'alert-type' => 'success'
            );
        }
        
        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data = Menu::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
    	DB::beginTransaction();

        try {

            Menu::find($id)->delete();

            DB::commit();

            $msg = 'Menu berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        }

        
    }
}
