<?php

namespace App\Http\Controllers;

use App\Models\JenisHaki;
use App\Models\PengajuanHaki;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\Auth;

class PengajuanHakiController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            if(Auth::user()->id_hak_akses == 1)
                $data = PengajuanHaki::all();
            else
                $data = PengajuanHaki::where('id_user', Auth::user()->id);

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<a href='.url('ajukan-haki/'.$id->id.'/edit').' title="Edit" class="btn btn-primary">Edit</a>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('pengajuan_haki.index');
    }

    public function tambah()
    {
        $data['jenis_haki'] = JenisHaki::all();
    	return view('pengajuan_haki.tambah', $data);
    }

    public function simpan(Request $req)
    {

        $id             = $req->id;
        $nama_pemohon   = $req->nama_pemohon;
        $pekerjaan      = $req->pekerjaan;
        $email          = $req->email;
        $telp           = $req->telp;
        $alamat         = $req->alamat;
        $nama_produk    = $req->nama_produk;
        $id_jenis_haki  = $req->id_jenis_haki;
        $deskripsi_produk  = $req->deskripsi_produk;
        $jumlah_produk  = $req->jumlah_produk;

        if(!empty($id)) {

            $pengajar = PengajuanHaki::find($id);

        } else {

            $pengajar = new PengajuanHaki;
            $pengajar->kode_pengajuan = PengajuanHaki::no_reg();
            $pengajar->id_user = Auth::user()->id;
            $pengajar->status = "Review";
        }

        $pengajar->nama_pemohon = $nama_pemohon;
        $pengajar->pekerjaan = $pekerjaan;
        $pengajar->email = $email;
        $pengajar->telp = $telp;
        $pengajar->alamat = $alamat;
        $pengajar->nama_produk = $nama_produk;
        $pengajar->id_jenis_haki = $id_jenis_haki;
        $pengajar->deskripsi_produk = $deskripsi_produk;
        $pengajar->jumlah_produk = $jumlah_produk;

        if($req->file_etiket != null)
        {
            $nama_file = "file_etiket_".time().'.'.$req->file_etiket->extension();

            $req->file_etiket->move('file_etiket', $nama_file);
            $pengajar->file_etiket = $nama_file;
        }

        if($req->file_ktp != null)
        {
            $nama_file = "file_ktp_".time().'.'.$req->file_ktp->extension();

            $req->file_ktp->move('file_ktp', $nama_file);
            $pengajar->file_ktp = $nama_file;
        }

        if($req->file_surat_pernyataan_umk != null)
        {
            $nama_file = "file_surat_pernyataan_umk_".time().'.'.$req->file_surat_pernyataan_umk->extension();

            $req->file_surat_pernyataan_umk->move('file_surat_pernyataan_umk', $nama_file);
            $pengajar->file_surat_pernyataan_umk = $nama_file;
        }

        if($req->file_surat_rekomendasi_umk != null)
        {
            $nama_file = "file_surat_rekomendasi_umk_".time().'.'.$req->file_surat_rekomendasi_umk->extension();

            $req->file_surat_rekomendasi_umk->move('file_surat_rekomendasi_umk', $nama_file);
            $pengajar->file_surat_rekomendasi_umk = $nama_file;
        }

        if($req->file_tanda_tangan != null)
        {
            $nama_file = "file_tanda_tangan_".time().'.'.$req->file_tanda_tangan->extension();

            $req->file_tanda_tangan->move('file_tanda_tangan', $nama_file);
            $pengajar->file_tanda_tangan = $nama_file;
        }

        $pengajar->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('ajukan-haki')->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data['pengajuan_haki'] = PengajuanHaki::findOrfail($id);
        $data['jenis_haki'] = JenisHaki::all();

        return view('pengajuan_haki.edit', $data);
    }

    public function hapus($id)
    {
        PengajuanHaki::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }
}
