<?php

namespace App\Http\Controllers;

use App\Models\JenisHaki;
use App\Models\PengajuanHaki;
use App\Models\PerbaikanHaki;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\Auth;

class PerbaikanHakiController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            if(Auth::user()->id_hak_akses == 1)
                $data = PerbaikanHaki::all();
            else
                $data = PerbaikanHaki::where('id_user', Auth::user()->id);

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<a href='.url('perbaikan-haki/'.$id->id.'/edit').' title="Edit" class="btn btn-primary">Edit</a>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('perbaikan_haki.index');
    }

    public function tambah()
    {
        $data['jenis_haki'] = JenisHaki::all();

        if(Auth::user()->id_hak_akses == 1)
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->get();
        else
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->where('id_user', Auth::user()->id)->get();

        $data['pengajuan_haki'] = $pengajuan_haki;
    	return view('perbaikan_haki.tambah', $data);
    }

    public function simpan(Request $req)
    {

        $id             = $req->id;
        $nama_pemohon   = $req->nama_pemohon;
        $pekerjaan      = $req->pekerjaan;
        $email          = $req->email;
        $telp           = $req->telp;
        $alamat         = $req->alamat;
        $nama_produk    = $req->nama_produk;
        $id_jenis_haki  = $req->id_jenis_haki;
        $deskripsi_produk  = $req->deskripsi_produk;
        $jumlah_produk  = $req->jumlah_produk;
        $id_pengajuan_haki  = $req->id_pengajuan_haki;
        $kode_pengajuan  = $req->kode_pengajuan;

        if(!empty($id)) {

            $pengajar = PerbaikanHaki::find($id);

        } else {

            $pengajar = new PerbaikanHaki;
            $pengajar->id_user = Auth::user()->id;
            $pengajar->status = "Review";
            $pengajar->kode_pengajuan = $kode_pengajuan;
            $pengajar->id_pengajuan_haki = $id_pengajuan_haki;
        }

        $pengajar->nama_pemohon = $nama_pemohon;
        $pengajar->pekerjaan = $pekerjaan;
        $pengajar->email = $email;
        $pengajar->telp = $telp;
        $pengajar->alamat = $alamat;
        $pengajar->nama_produk = $nama_produk;
        $pengajar->id_jenis_haki = $id_jenis_haki;
        $pengajar->deskripsi_produk = $deskripsi_produk;
        $pengajar->jumlah_produk = $jumlah_produk;

        if($req->file_etiket != null)
        {
            $nama_file = "file_etiket_".time().'.'.$req->file_etiket->extension();

            $req->file_etiket->move('file_etiket', $nama_file);
            $pengajar->file_etiket = $nama_file;
        }

        if($req->file_ktp != null)
        {
            $nama_file = "file_ktp_".time().'.'.$req->file_ktp->extension();

            $req->file_ktp->move('file_ktp', $nama_file);
            $pengajar->file_ktp = $nama_file;
        }

        if($req->file_surat_pernyataan_umk != null)
        {
            $nama_file = "file_surat_pernyataan_umk_".time().'.'.$req->file_surat_pernyataan_umk->extension();

            $req->file_surat_pernyataan_umk->move('file_surat_pernyataan_umk', $nama_file);
            $pengajar->file_surat_pernyataan_umk = $nama_file;
        }

        if($req->file_surat_rekomendasi_umk != null)
        {
            $nama_file = "file_surat_rekomendasi_umk_".time().'.'.$req->file_surat_rekomendasi_umk->extension();

            $req->file_surat_rekomendasi_umk->move('file_surat_rekomendasi_umk', $nama_file);
            $pengajar->file_surat_rekomendasi_umk = $nama_file;
        }

        if($req->file_tanda_tangan != null)
        {
            $nama_file = "file_tanda_tangan_".time().'.'.$req->file_tanda_tangan->extension();

            $req->file_tanda_tangan->move('file_tanda_tangan', $nama_file);
            $pengajar->file_tanda_tangan = $nama_file;
        }

        $pengajar->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('perbaikan-haki')->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data['pengajuan_haki'] = PerbaikanHaki::findOrfail($id);
        $data['jenis_haki'] = JenisHaki::all();

        return view('perbaikan_haki.edit', $data);
    }

    public function hapus($id)
    {
        PerbaikanHaki::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    function get_pengajuan_haki($kode_pengajuan)
    {
        $pengajuan_haki = PengajuanHaki::where('kode_pengajuan', $kode_pengajuan)->first();

        $data['pengajuan_haki'] = $pengajuan_haki;

        return response()->json($pengajuan_haki, 200);
    }
}
