<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Dukcapil;
use App\Models\IndeksDukcapil;
use Auth;

class PetaController extends Controller
{
    public function index()
    {
        return view('peta.index');
    }

    public function get_kordinat()
    {
        $id_hak_akses = Auth::user()->id_hak_akses;
        $id_provinsi = request()->get('id_provinsi');
        $id_kabupaten = request()->get('id_kabupaten');
        $id_kecamatan = request()->get('id_kecamatan');
        $id_kelurahan = request()->get('id_kelurahan');

        if($id_provinsi == null && $id_kabupaten == null && $id_kecamatan == null && $id_kelurahan == null)
        {
            $data = $this->get_data_dukcapil($id_hak_akses);
        }
        else if($id_kelurahan != null)
        {
            $data = Dukcapil::where('id_kelurahan', $id_kelurahan)->get();
        }
        else if($id_kecamatan != null)
        {
            $data = Dukcapil::where('id_kecamatan', $id_kecamatan)->get();
        }
        else if($id_kabupaten != null)
        {
            $data = Dukcapil::where('id_kabupaten', $id_kabupaten);

            if($id_hak_akses == 5)
            {
                $data = $data->where('id_kecamatan', Auth::user()->id_kecamatan)->get();
            }
            else
            {
                $data = $data->get();
            }
        }
        else if($id_provinsi != null)
        {
            $data = Dukcapil::where('id_provinsi', $id_provinsi);

            if($id_hak_akses == 4)
            {
                $data = $data->where('id_kabupaten', Auth::user()->id_kabupaten)->get();
            }
            else
            {
                $data = $data->get();
            }
        }

        return response()->json($data);
    }

    public function get_detail($id)
    {
        $dukcapil = Dukcapil::find($id);
        $indeks = IndeksDukcapil::where('id_dukcapil', $id)->first();
        
        $data_detail['dukcapil'] = $dukcapil;
        $data_detail['indeks'] = $indeks;

        $data['dukcapil'] = $dukcapil;
        $data['detail_dukcapil'] = view('dukcapil._detail_dukcapil', $data_detail)->render();

        $result = view('peta.detail', $data)->render();

        return $result;
    }

    public function get_data_dukcapil($id_hak_akses)
    {
        if($id_hak_akses == 1) //admin
        {
            $data = Dukcapil::whereNotNull('latitude')->whereNotNull('longitude')->get();
        }
        else if($id_hak_akses == 3) //admin prov
        {
            $data = Dukcapil::where('id_provinsi', Auth::user()->id_provinsi)->whereNotNull('latitude')->whereNotNull('longitude')->get();
        }
        else if($id_hak_akses == 4) //admin kab
        {
            $data = Dukcapil::where('id_kabupaten', Auth::user()->id_kabupaten)->whereNotNull('latitude')->whereNotNull('longitude')->get();
        }
        else if($id_hak_akses == 5) //admin kec
        {
            $data = Dukcapil::where('id_kecamatan', Auth::user()->id_kecamatan)->whereNotNull('latitude')->whereNotNull('longitude')->get();
        }
        else
        {
            $data = Dukcapil::whereNotNull('latitude')->whereNotNull('longitude')->where('id_user', Auth::user()->id)->get(); // sementara sama seperti admin dulu
        }

        return $data;
    }
}
