<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Variabel;
use App\Models\Dimensi;
use App\Models\Aspek;
use DataTables;

class VariabelController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Variabel::orderBy('variabels.id','ASC');
            // $data = Variabel::select(['variabels.*','b.nama as aspek'])
            //             ->join('aspeks as b','variabels.id_aspek','=','b.id')
            //             ->orderBy('variabels.id','ASC')
            //             ->get();
            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
        // $data['dimensi'] = Dimensi::all();
        // $data['aspek'] = Aspek::all();
    	return view('variabel.index');
    }

    public function tambah(Request $req)
    {

        $id         = $req->id;
        $name       = $req->name;
        // $persentase = str_replace(",",".",$req->persentase);
        // $id_dimensi   = $req->id_dimensi;
        // $id_aspek   = $req->id_aspek;
        $pesan          = "";

        if(!empty($id)) {

            $pengajar = Variabel::find($id);
            $pengajar->nama = $name;
            // $pengajar->persentase = $persentase;
            // $pengajar->id_dimensi = $id_dimensi;
            // $pengajar->id_aspek = $id_aspek;
            $pengajar->save();

            $data['message'] = 'Data berhasil diubah';
            $data['issuccess'] = true;

        } else {

            $pengajar = new Variabel;
            $pengajar->nama = $name;
            // $pengajar->persentase = $persentase;
            // $pengajar->id_dimensi = $id_dimensi;
            // $pengajar->id_aspek = $id_aspek;
            $pengajar->save();

            $data['message'] = 'Data berhasil disimpan';
            $data['issuccess'] = true;
        }


        return response()->json($data, 200);

    }

    public function edit($id)
    {
        $data = Variabel::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
        Variabel::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    public function get_info_dimensi($id_dimensi)
    {
        $dimensi = Dimensi::find($id_dimensi);
        $total_saat_ini = Variabel::where('id_dimensi', $id_dimensi)->sum('persentase');

        $data['persentase'] = $dimensi->persentase;
        $data['total_saat_ini'] = $total_saat_ini;

        return response()->json($data);
    }

    public function get_info_aspek($id_aspek)
    {
        $aspek = Aspek::find($id_aspek);
        $total_saat_ini = Variabel::where('id_aspek', $id_aspek)->sum('persentase');

        $data['persentase'] = $aspek->persentase;
        $data['total_saat_ini'] = $total_saat_ini;

        return response()->json($data);
    }
}
