<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Carbon\Carbon;

class HakAkses extends Model
{
    use HasFactory;

    protected $table = 'hak_akses';
    protected $primaryKey = 'id';
    protected $fillable = ['nama_hak_akses'];

    const Admin = 1;
    const User = 2; //Masyarakat
    const AdminProvinsi = 3;
    const AdminKabupaten = 4;
    const AdminKecamatan = 5;
    const Pendamping = 6;

    public function user()
    {
    	return $this->hasMany(User::class, 'id_hak_akses');
    }

    public function hak_akses_user()
    {
        return $this->HasMany(HakAksesUser::class, 'id_hak_akses');
    }

    public static function simpan($nama_hak_akses)
    {
        $hak_akses = new HakAkses;
        $hak_akses->nama_hak_akses = $nama_hak_akses;
        $hak_akses->save();

        return $hak_akses;
    }

    public static function edit_hak_akses($id)
    {
        $hak_akses = HakAkses::findOrfail($id);
        return $hak_akses;
    }

    public static function update_hak_akses($id, $nama_hak_akses)
    {
        DB::table('hak_akses')->where('id', $id)->update(['nama_hak_akses' => $nama_hak_akses, 'updated_at'=> Carbon::now()]);
    }
}
