<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Carbon\Carbon;

class HakAksesUser extends Model
{
    use HasFactory;

    protected $table = 'hak_akses_user';
    protected $primaryKey = 'id';
    protected $fillable = ['id_hak_akses','id_menu'];

    public function hak_akses()
    {
    	return $this->belongsTo(HakAkses::class, 'id_hak_akses');
    }

    public function menu()
    {
    	return $this->belongsTo(Menu::class, 'id_menu');
    }

    public static function simpan($id_hak_akses, $id_menu)
    {
        $hak_akses_admin = new HakAksesUser;
        $hak_akses_admin->id_hak_akses = $id_hak_akses;
        $hak_akses_admin->id_menu = $id_menu;
        $hak_akses_admin->save();
    }

    public static function edit_hak_akses_user($id)
    {
        $hak_akses_user = HakAksesUser::findOrfail($id);
        return $hak_akses_user;
    }

    public static function update_hak_akses_user($id, $id_hak_akses, $id_menu)
    {
        DB::table('hak_akses_user')->where('id', $id)->update(['id_hak_akses' => $id_hak_akses, 'id_menu' => $id_menu, 'updated_at'=> Carbon::now()]);
    }

    public static function hapus($id)
    {
        $hapus = DB::table('hak_akses_user')->where('id_hak_akses', '=', $id)->delete();

        return $hapus;
    }
}
