<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Models\HakAkses;

class Layanan extends Model
{
    use HasFactory;

    protected $table = 'layanans';

    public static function GetAktif()
    {
        $data = self::where('is_aktif', 1);
        $id_hak_akses = Auth::user()->id_hak_akses;

        if($id_hak_akses == HakAkses::Admin)
        {
            return $data;
        }
        else if($id_hak_akses == HakAkses::User)
        {
            return $data->where('id_kabupaten', Auth::user()->id_kabupaten)->OrWhere('id_provinsi', Auth::user()->id_provinsi);
        }
        else if($id_hak_akses == HakAkses::AdminProvinsi)
        {
            return $data->where('id_provinsi', Auth::user()->id_provinsi);
        }
        else if($id_hak_akses == HakAkses::AdminKabupaten)
        {
            return $data->where('id_kabupaten', Auth::user()->id_kabupaten);
        }
        else{
            return $data; //sementara
        }        
    }

    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'id_provinsi');
    }

    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'id_kabupaten');
    }

}
