<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    protected $table = 'menu';
    protected $primaryKey = 'id';
    protected $fillable = ['id_induk','menu','icon','url','no_urut','page_title'];

    public function childs() 
    {
       return $this->hasMany(Menu::class,'id_induk','id') ;
    }

    public function childs_menu() 
    {
       return $this->belongsTo(Menu::class,'id_induk','id') ;
    }

    public function hak_akses_user()
    {
    	return $this->hasMany(HakAksesUser::class,'id_menu');
    }
}
