<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PendaftaranProgram extends Model
{
    use HasFactory;

    protected $table = 'pendaftaran_programs';

    const STATUSDITERIMA = "Diterima";
    const STATUSDITOLAK = "Ditolak";
    const STATUSMENUNGGU = "Menunggu Keputusan";

    public static function no_reg() {

        $tmp = "REG".date('Ymd');
        $last_no_app = self::where('no_pendaftaran', 'like', $tmp .'%' )->orderBy('created_at', 'DESC')->first();

        if($last_no_app === null) {

            $no_selanjut_y =$tmp."00001";

        } else {

            $x = substr($last_no_app->no_pendaftaran, 11);
            $x = $x + 1;

            $panjang_x = strlen($x);

            if($panjang_x == 5) {
                $no_selanjut_y= $tmp.$x;
            } else if ($panjang_x == 4){
                $no_selanjut_y= $tmp."0".$x;
            } else if ($panjang_x == 3){
                $no_selanjut_y= $tmp."00".$x;
            } else if($panjang_x == 2){
                $no_selanjut_y= $tmp."000".$x;
            } else if($panjang_x == 1){
                $no_selanjut_y= $tmp."0000".$x;
            } else {
                $no_selanjut_y= $tmp."00000";
            }
        }
        return $no_selanjut_y;
    }

    public function program()
    {
        return $this->belongsTo(Program::class, 'id_program');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
}
