<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PengajuanHaki extends Model
{
    use HasFactory;

    protected $table = 'pengajuan_haki';

    public function jenis_haki()
    {
        return $this->belongsTo(JenisHaki::class, 'id_jenis_haki');
    }

    public static function no_reg() {

        $tmp = "REG".date('Ymd');
        $last_no_app = self::where('kode_pengajuan', 'like', $tmp .'%' )->orderBy('created_at', 'DESC')->first();

        if($last_no_app === null) {

            $no_selanjut_y =$tmp."00001";

        } else {

            $x = substr($last_no_app->kode_pengajuan, 11);
            $x = $x + 1;

            $panjang_x = strlen($x);

            if($panjang_x == 5) {
                $no_selanjut_y= $tmp.$x;
            } else if ($panjang_x == 4){
                $no_selanjut_y= $tmp."0".$x;
            } else if ($panjang_x == 3){
                $no_selanjut_y= $tmp."00".$x;
            } else if($panjang_x == 2){
                $no_selanjut_y= $tmp."000".$x;
            } else if($panjang_x == 1){
                $no_selanjut_y= $tmp."0000".$x;
            } else {
                $no_selanjut_y= $tmp."00000";
            }
        }
        return $no_selanjut_y;
    }

    // public function materi()
    // {
    //     return $this->belongsTo(Materi::class, 'id_materi');
    // }
}
