<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TableDiklat extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('programs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 500);
            $table->integer('id_pengajar');
            $table->float('harga', 18,2)->nullable();
            $table->integer('kuota')->nullable();
            $table->date('mulai')->nullable();
            $table->date('selesai')->nullable();
            $table->string('tipe_program',255)->nullable();
            $table->text('lokasi')->nullable();
            $table->string('status',255)->nullable();
            $table->timestamps();
        });

        Schema::create('pendaftaran_programs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('no_pendaftaran', 500)->nullable();
            $table->integer('id_program');
            $table->integer('id_user');
            $table->string('status',255)->nullable(); //Diterima/Ditolak/Menunggu Keputusan
            $table->timestamps();
        });

        Schema::create('pembayarans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_pendaftaran_program')->nullable();
            $table->string('no_transaksi', 500)->nullable();
            $table->float('total_bayar', 18,2)->nullable();
            $table->string('bukti_pembayaran', 255)->nullable();
            $table->string('status',255)->nullable();
            $table->timestamps();
        });

        Schema::create('materis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_program');
            $table->string('nama', 500)->nullable();
            $table->text('deskripsi')->nullable();
            $table->timestamps();
        });

        Schema::create('moduls', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_materi');
            $table->string('nama', 500)->nullable();
            $table->string('tipe', 500)->nullable();
            $table->string('file', 500)->nullable();
            $table->text('deskripsi')->nullable();
            $table->timestamps();
        });

        Schema::create('pengajarans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_program');
            $table->integer('id_materi');
            $table->date('tanggal')->nullable();
            $table->time("jam_mulai")->nullable();
            $table->time("jam_selesai")->nullable();
            $table->string("link_zoom", 500)->nullable();
            $table->timestamps();
        });

        Schema::create('soals', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_program');
            $table->text('soal')->nullable();
            $table->float('skor',18,2)->nullable();
            $table->string("file", 500)->nullable();
            $table->timestamps();
        });

        Schema::create('jawabans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_soal');
            $table->text('jawaban')->nullable();
            $table->boolean('jawaban_benar')->nullable();
            $table->timestamps();
        });

        Schema::create('ujians', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_program');
            $table->date('tanggal')->nullable();
            $table->time("jam_mulai")->nullable();
            $table->time("jam_selesai")->nullable();
            $table->float("syarat_kelulusan", 18,2)->nullable();
            $table->string("status")->nullable();
            $table->timestamps();
        });

        Schema::create('peserta_ujians', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_ujian');
            $table->integer('id_user');
            $table->time("jam_mulai")->nullable();
            $table->time("jam_selesai")->nullable();
            $table->string("status")->nullable();
            $table->timestamps();
        });

        Schema::create('jawaban_peserta_ujians', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_peserta_ujian');
            $table->integer('id_soal');
            $table->integer('id_jawaban');
            $table->boolean('jawaban_benar');
            $table->timestamps();
        });

        Schema::create('sertifikats', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_program');
            $table->integer('id_user');
            $table->timestamps();
        });

        Schema::create('pengajars', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 500);
            $table->string('email', 500)->nullable();
            $table->string('jenis_kelamin')->nullable();
            $table->string('no_telp')->nullable();
            $table->text('alamat')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
