<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTableModal extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permisis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_kecamatan');
            $table->integer('id_kelurahan');
            $table->string('email',255)->nullable();
            $table->string('no_hp',255)->nullable();
            $table->string('no_skpwni',255)->nullable();
            $table->text('alamat')->nullable();
            $table->string('rt',255)->nullable();
            $table->string('rw',255)->nullable();
            $table->string('kode_pos',255)->nullable();
            $table->integer('id_klasifikasi_kepindahan')->nullable();
            $table->string('lokasi_kepindahan',255)->nullable();
            $table->date('tanggal_pengambilan')->nullable();
            $table->string('file_skpwni', 255)->nullable();
            $table->timestamps();
        });

        Schema::create('klasifikasi_kepindahans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('halo_pamors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nik', 255);
            $table->timestamps();
        });

        Schema::create('anduk_bang_beks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('no_kk', 255);
            $table->string('nik', 255);
            $table->string('nama_lengkap', 255);
            $table->integer('id_kecamatan');
            $table->integer('id_kelurahan');
            $table->text('alamat')->nullable();
            $table->string('rt',255)->nullable();
            $table->string('rw',255)->nullable();
            $table->string('email',255)->nullable();
            $table->string('no_hp',255)->nullable();
            $table->integer('id_jenis_permohonan_bang_bek')->nullable();
            $table->string('hub_dimohonkan',255)->nullable();
            $table->integer('id_jenis_layanan')->nullable();
            $table->integer('jumlah_jiwa')->nullable();
            $table->integer('id_alasan_permohonan')->nullable();
            $table->text('keterangan_lainnya')->nullable();
            $table->string('file_kk_pemohon', 255)->nullable();
            $table->string('file_ktp_pemohon', 255)->nullable();
            $table->string('file_kk_dimohonkan', 255)->nullable();
            $table->string('file_ktp_dimohonkan', 255)->nullable();
            $table->timestamps();
        });

        Schema::create('jenis_permohonan_bang_beks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });
        Schema::create('jenis_pelayanans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });
        Schema::create('alasan_permohonans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('siti_bawa_ludos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('no_kk', 255);
            $table->string('nik', 255);
            $table->string('nama_lengkap', 255);
            $table->string('tempat_lahir', 255);
            $table->date('tanggal_lahir');
            $table->string('email',255)->nullable();
            $table->string('no_hp',255)->nullable();
            $table->integer('id_dasar_permohonan')->nullable();
            $table->integer('id_kecamatan')->nullable();
            $table->integer('id_kelurahan')->nullable();
            $table->text('alamat')->nullable();
            $table->string('rt',255)->nullable();
            $table->string('rw',255)->nullable();
            $table->integer('id_status_tinggal')->nullable();
            $table->integer('id_provinsi_ktp')->nullable();
            $table->integer('id_kabupaten_ktp')->nullable();
            $table->integer('id_kecamatan_ktp')->nullable();
            $table->integer('id_kelurahan_ktp')->nullable();
            $table->text('alamat_ktp')->nullable();
            $table->string('rt_ktp',255)->nullable();
            $table->string('rw_ktp',255)->nullable();
            $table->timestamps();
        });

        Schema::create('dasar_permohonans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });
        Schema::create('status_tinggals', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('moto_ktps', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('no_kk', 255);
            $table->string('nik', 255);
            $table->string('nama_lengkap', 255);
            $table->integer('id_kecamatan')->nullable();
            $table->integer('id_kelurahan')->nullable();
            $table->text('alamat')->nullable();
            $table->string('rt',255)->nullable();
            $table->string('rw',255)->nullable();
            $table->string('email',255)->nullable();
            $table->string('no_hp',255)->nullable();
            $table->integer('id_jenis_permohonan_moto_ktp')->nullable();
            $table->timestamps();
        });

        Schema::create('jenis_permohonan_moto_ktps', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 255);
            $table->timestamps();
        });

        Schema::create('sip_oras', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('no_paspor', 255)->nullable();
            $table->string('no_kitas', 255)->nullable();
            $table->string('nama_lengkap', 255);
            $table->string('kewarganegaraan', 255)->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->string('sponsor', 255)->nullable();
            $table->string('email_sponsor', 255)->nullable();
            $table->string('no_hp_sponsor', 255)->nullable();
            $table->integer('id_kecamatan')->nullable();
            $table->integer('id_kelurahan')->nullable();
            $table->text('alamat')->nullable();
            $table->string('rt',255)->nullable();
            $table->string('rw',255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
