<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Layanan extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('layanans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nama', 500);
            $table->string('image')->nullable();
            $table->boolean('is_aktif');
            $table->text('keterangan')->nullable();
            $table->timestamps();
        });
        Schema::create('layanan_fields', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_layanan');
            $table->string('nama', 255);
            $table->string('tipe');
            $table->boolean('is_master')->nullable();
            $table->string('master_data', 255)->nullable();
            $table->string('jenis_file', 255)->nullable();
            $table->timestamps();
        });
        Schema::create('layanan_field_dropdown_values', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_layanan_field');
            $table->text('value');
            $table->timestamps();
        });
        Schema::create('user_layanans', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_user');
            $table->integer('id_layanan');
            $table->string('status');
            $table->timestamps();
        });
        Schema::create('user_layanan_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_user_layanan');
            $table->integer('id_layanan_field');
            $table->text('value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
